/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"config.h"
#include	"fips_S.h"
#ifndef DEA_TEST
# include       "dea_conf.h"
#endif  /* DEA_TEST */


/*
 * Bit rotate for the four least significant bits.
 */

static
#ifdef __SDTC__
	const
#endif
		unsigned char	r[16] = {
					0x0, /* 0000 -> 0000 */
					0x8, /* 0001 -> 1000 */
					0x4, /* 0010 -> 0100 */
					0xc, /* 0011 -> 1100 */
					0x2, /* 0100 -> 0010 */
					0xa, /* 0101 -> 1010 */
					0x6, /* 0110 -> 0110 */
					0xe, /* 0111 -> 1110 */
					0x1, /* 1000 -> 0001 */
					0x9, /* 1001 -> 1001 */
					0x5, /* 1010 -> 0101 */
					0xd, /* 1011 -> 1101 */
					0x3, /* 1100 -> 0011 */
					0xb, /* 1101 -> 1011 */
					0x7, /* 1110 -> 0111 */
					0xf  /* 1111 -> 1111 */
				};

/*
 * This program generates a macro for us as the S - selection.
 *
 *		S(B)
 *
 * The input is 48 bits stored in an array of unsigned character `B[0--7]'
 * with six bit in the six least significant bits of each character.
 * The least significant bit of each character is the first of each with
 * the least significant bit of `B[0]' as the first in the input block.
 *
 * The output is 32 bits in an unsigned long with the least significant bit
 * as the first.
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


#define DES_KS_BITS_PER_BYTE \
	(UNSIGNED_CHAR_BITS - ((DES_BITS - DES_KS_BITS) / DES_BLOCK_BYTES))

#define DES_KS_BYTE_MAX = ((0x1 << DES_KS_BITS_PER_BYTE) - 1)

main(argc, argv)
int	argc;
char	*argv[];
{
	register int	i, j, sb, n, v;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

        (void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");

	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);
		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\ts = {\n", base);
		for (sb = 0; sb < S_BOXES; sb++) {
			(void) printf("\t\t\t{ /* S%d                (i,  j) -> out */\n",
				      sb + 1);
			for (n = 0; n < DES_KS_BYTE_MAX + 1; n++) {
				i = ((n & 0x01) << 1) | ((n & 0x20) >> 5);
				j = r[(n & 0x1e) >> 1];
				v = s[sb][i][j];
				(void) printf("\t\t\t\t0x%08lxl%c /* (%d, %2d) -> %2d */\n",
					      ((unsigned long) r[v]) <<
					       (sb * (UNSIGNED_CHAR_BITS / 2)),
					      (n + 1 < DES_BITS) ? ',' : ' ', i, j, v);
			}
			(void) printf(((sb + 1) < S_BOXES) ? "\t\t\t},\n" : "\t\t\t}\n");
		}
		(void) printf("\t\t};\n");
	} else {
		(void) printf("#define S(B) ( \\\n");
		for (sb = 0; sb < S_BOXES; sb++) {
			(void) printf("\ts[%d][B[%d]]", sb, sb);
			(void) printf((sb + 1 < S_BOXES) ? " | \\\n" : " \\\n");
		}
		(void) printf(")\n\n");
		(void) printf("typedef unsigned long\t%s_t[%d][%d];\n\n",
			    base, S_BOXES, DES_KS_BYTE_MAX + 1);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\ts;\n", base);
	)

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
