/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdlib.h>
#include	<stdio.h>
#include	"des.h"
#include	"tty.h"
#include	"config.h"
#include	"getpass2.h"
#include	"version.h"

/*
 * des_read_cblock
 *
 *	This routine shows the string `prompt' on the current tty and reads
 *	a line from the current tty. If the `verify' argument is non-zero,
 *	then a second prompt requesting verification is shown. If the first
 *	and second lines do not match, then the process is tried again until
 *	both match.
 *
 *	The input echo is switched off during the operation.
 *
 *	The string (excluding any newline) is converted to a DES cblock
 *	with `des_hex_to_cblock'. If `des_hex_to_cblock' failes, the
 *	opeartion id done until the string is accepted.
 *
 *	`des_read_cblock' returns 0 if the operation was successful,
 *	-1 if the echo could not be switched off or -2 if the input string
 *	could not be obtained. In the last case, no key is generated.
 */


static
#ifdef __SDTC__
	const
#endif
		char	*err_msg = "Not a 64-bit hex. value, try again.\n";


int	des_read_cblock(
#ifdef __STDC__
	des_cblock	*cblock,
	char		*prompt,
	int		verify)
#else
	cblock, prompt, verify)
des_cblock	*cblock;
char		*prompt;
int		verify;
#endif
{
	register int	retry;
	register char	*hexstr;
	char		buf[19];
#ifdef TTY
	FILE		*ttyfd;
#endif /* TTY */


	do {

		hexstr = getpass2(prompt, buf, sizeof(buf), verify);

		/* Make a des key from the string key. */
		retry = (hexstr) ? des_hex_to_cblock(hexstr, cblock) : 1;

		if (retry)  {
#ifdef TTY
			ttyfd = fopen(TTY, "w");
			if (ttyfd) {
				(void) fputs(err_msg, ttyfd);
				(void) fclose(ttyfd);
			}
#else  /* TTY */
			(void) fputs(err_msg, stderr);
#endif /* TTY */
		}

	} while (retry);

	return getpass2_error;
}
