/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	"des.h"
#include	"config.h"

/*
 * This program generates a table to use for key parity adjustment.
 *
 */

static char	*prog;
static char	*base;
static int	c_file = 0;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int		i, bit;
	register unsigned char	res, p;


        prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;
	if (argc != 3 || (strcmp(argv[1], "-c") && strcmp(argv[1], "-h")))
		goto usage;
	c_file = strcmp(argv[1], "-h");
	base = argv[2];

	(void) printf("/*\n");
	(void) printf(" * This file is automaticly generated, do not change.\n");
	(void) printf(" */\n\n");
	
	if (c_file) {
		(void) printf("#include\t\"local_def.h\"\n#include\t\"version.h\"\n");
		(void) printf("#include\t\"%s.h\"\n\n", base);

		(void) printf("#ifdef __SDTC__\nconst\n#endif\n");
		(void) printf("\t%s_t\tparity_tab[%d] = {\n",
			      base, UNSIGNED_CHAR_MAX + 1);

		for (i = 0; i <= UNSIGNED_CHAR_MAX; i++) {

#ifdef DES_LSB_FIRST
			res = ((unsigned char) i) & 0x7F;
			for (p = 0x80, bit = 0x01; bit < 0x80; bit <<= 1)
				if (res & bit)
					p ^= 0x80;
#else  /* DES_LSB_FIRST */
			res = ((unsigned char) i) & 0xFE;
			for (p = 0x01, bit = 0x80; bit > 0x01; bit >>= 1)
				if (res & bit)
					p ^= 0x01;
#endif /* DES_LSB_FIRST */
			res |= p;

			(void) printf("\t\t\t\t0x%02x%s\t/* %3d, 0x%02x */\n",
				      res,
				      (i < UNSIGNED_CHAR_MAX) ? "," : "",
				      i, i);
		}
		(void) printf("\t\t\t};\n");
	} else {
		(void) printf("typedef unsigned char\t%s_t;\n\n", base);
		(void) printf("extern\n#ifdef __SDTC__\n\tconst\n#endif\n");
		(void) printf("\t\t%s_t\tparity_tab[%d];\n",
			      base, UNSIGNED_CHAR_MAX + 1);
	}

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s -c|-h base\n", prog);
	exit(1);
}
