/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<des.h>
#include	"env.h"
#include	"str.h"
#include	"getkey.h"
#include	"getivec.h"
#include	"core.h"
#include	"mode.h"
#include	"compat.h"
#include	"config.h"
#include	"version.h"


#define a_FLAG	0x0001L
#define b_FLAG	0x0002L
#define c_FLAG	0x0004L
#define d_FLAG	0x0008L
#define e_FLAG	0x0010L
#define f_FLAG	0x0020L
#define g_FLAG	0x0040L
#define h_FLAG	0x0080L
#define i_FLAG	0x0100L
#define k_FLAG	0x0200L
#define m_FLAG	0x0400L
#define n_FLAG	0x0800L
#define o_FLAG	0x1000L
#define v_FLAG	0x2000L


char		*prog;
unsigned long	flags = 0L;


main(argc, argv)
int	argc;
char	*argv[];
{
	register int		i, j, o, cr, mode, keys;
	register int		key_flags, ivec_flags;
	register char		*core_name, *mode_name, *compat_name;
	register core_mode	*core;
	register crypt_mode	*crypt;
	register crypt_compat	*compat;
	register file_func	file;
	io_mode			io;
	char			*key_spec[DES_MAX_KEYS], *ivec_spec, *ovec_spec;
	des_key_schedule	schedule[DES_MAX_KEYS];
	des_cblock		key[DES_MAX_KEYS], ivec;
	extern int		optind;
	extern char		*optarg;


	/* The program name. */
	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;

	/* Set initial values. */
	cr = 0;
	core = (core_mode *) 0;
	crypt = (crypt_mode *) 0;
	file = (file_func) 0;
	compat = NULL;
	mode = DES_ENCRYPT;
	keys = 0;
	key_flags = KEY_VERIFY_FLAG;
	ivec_flags = IVEC_VERIFY_FLAG;
	for (i = 0; i < DES_MAX_KEYS; i++)
		key_spec[i] = NULL;
	ivec_spec = NULL;
	ovec_spec = NULL;
	core_name = NULL;
	mode_name = NULL;
	compat_name = NULL;
	io.rname = "<stdin>";
	io.wname = "<stdout>";
	io.rfd = stdin;
	io.wfd = stdout;
	io.read = (io_func) fread;
	io.write = (io_func) fwrite;
	des_return_ivec = DES_RETURN_IVEC;

	/* Get the command line arguments. */
	while ((o = getopt(argc, argv, "ab:cdef:hi:k:m:n:o:v:")) != EOF)
		switch (o) {
		case 'a':
			if (flags & a_FLAG)
				goto usage;
			io.read = (io_func) ascii_read;
			io.write = (io_func) ascii_write;
			flags |= a_FLAG;
			break;
		case 'b':
			if (flags & b_FLAG)
				goto usage;
			if ((compat_name = new_string(optarg)) == NULL)
				goto memalloc;
			flags |= b_FLAG;
			break;
		case 'c':
			if (flags & (c_FLAG | d_FLAG | e_FLAG | m_FLAG))
				goto usage;
			flags |= c_FLAG;
			break;
		case 'd':
			if (flags & (c_FLAG | d_FLAG | e_FLAG))
				goto usage;
			mode = DES_DECRYPT;
			flags |= d_FLAG;
			break;
		case 'e':
			if (flags & (c_FLAG | d_FLAG | e_FLAG))
				goto usage;
			mode = DES_ENCRYPT;
			flags |= e_FLAG;
			break;
		case 'f':
			if (flags & (f_FLAG | k_FLAG))
				goto usage;
			if ((key_spec[0] = new_string(optarg)) == NULL)
				goto memalloc;
			/* Destroy the argument vector key. */
			null_string(optarg);
			flags |= f_FLAG;
			key_flags |= KEY_FILE_FLAG;
			break;
		case 'h':
			if (flags & h_FLAG)
				goto usage;
			flags |= h_FLAG;
			key_flags |= KEY_HEX_FLAG;
			break;
		case 'i':
			if (flags & (i_FLAG | v_FLAG))
				goto usage;
			if (*optarg != '\0') {
				if ((ivec_spec = new_string(optarg)) == NULL)
					goto memalloc;
				/* Destroy the argument vector key. */
				ivec_flags |= IVEC_STRING_FLAG;
			} else
				ivec_flags |= IVEC_PROMPT_FLAG;
			null_string(optarg);
			flags |= i_FLAG;
			break;
		case 'k':
			if (flags & f_FLAG || keys >= DES_MAX_KEYS)
				goto usage;
			if ((key_spec[keys++] = new_string(optarg)) == NULL)
				goto memalloc;
			/* Destroy the argument vector ivec. */
			null_string(optarg);
			flags |= k_FLAG;
			key_flags |= KEY_STRING_FLAG;
			break;
		case 'm':
			if (flags & (c_FLAG | m_FLAG))
				goto usage;
			if ((mode_name = new_string(optarg)) == NULL)
				goto memalloc;
			flags |= m_FLAG;
			break;
		case 'n':
			if (flags & n_FLAG)
				goto usage;
			if ((core_name = new_string(optarg)) == NULL)
				goto memalloc;
			flags |= n_FLAG;
			break;
		case 'o':
			if (flags & o_FLAG)
				goto usage;
			if ((ovec_spec = new_string(optarg)) == NULL)
				goto memalloc;
			/* Destroy the argument vector ovec. */
			null_string(optarg);
			flags |= o_FLAG;
			break;
		case 'v':
			if (flags & (i_FLAG | v_FLAG))
				goto usage;
			if ((ivec_spec = new_string(optarg)) == NULL)
				goto memalloc;
			/* Destroy the argument vector key. */
			null_string(optarg);
			flags |= v_FLAG;
			ivec_flags |= IVEC_FILE_FLAG;
			break;
		case '?':
		default:
			goto usage;
		}
	if (!(flags & (c_FLAG | d_FLAG | e_FLAG)))
		goto usage;

	switch (argc - optind) {
	case 2:
		io.wname = argv[optind + 1];
		if (io.wname[0] != '-' || io.wname[1] != '\0')
			io.wfd = NULL;
	case 1:
		io.rname = argv[optind];
		if (io.rname[0] != '-' || io.rname[1] != '\0')
			io.rfd = NULL;
	case 0:
		break;
	default:
		goto usage;
	}

	/* Select encryption/decryption core algorithm */
	if (!(core = getcore(core_name)))
		goto nocore;
	if (flags & n_FLAG) {
		free(core_name);
		core_name = NULL;
	}
	des_core = core->func;

	if (flags & k_FLAG && keys != core->no_keys)
		goto usage;

	/* Select encryption/decryption mode */
	if (flags & c_FLAG) {
		crypt = (crypt_mode *) &mode_chksum;
		file = crypt->file;
	} else {
		if (!(crypt = getmode(mode_name)))
			goto nomode;
		if (flags & m_FLAG) {
			free(mode_name);
			mode_name = NULL;
		}
		/* Ascii input/output requires padding */
		file = (flags & a_FLAG) ? crypt_file_padding : crypt->file;
	}

	if (!(compat = getcompat(compat_name)))
		goto nocompat;
	if (flags & b_FLAG) {
		free(compat_name);
		compat_name = NULL;
	}
	des_strkey = compat->strkey;
	pad_data = compat->pad_data;

	/* If there was no key set on the argument line, fetch one from	*/
	/* the tty.							*/
	if (core->no_keys != getkey(key, key_spec, core->no_keys, key_flags))
		goto nokey;
	for (i = 0; i < DES_MAX_KEYS; i++)
		if (key_spec[i] != NULL) {
			null_string(key_spec[i]);
			free(key_spec[i]);
		}

	if (getivec(ivec, ivec_spec, ivec_flags) < 0)
		goto noivec;
	if (ivec_spec != NULL) {
		null_string(ivec_spec);
		free(ivec_spec);
	}

	/* Make the key schedule(s) */
	for (i = 0; i < core->no_keys; i++) {
		if (des_key_sched((des_cblock *) key[i], schedule[i]) < 0)
			goto weakkey;
		DES_ZERO_CBLOCK(key[i]);
	}

	/* Open the file(s) */
	if (io.rfd == NULL) {
		/* Open the source file. */
		if ((io.rfd = fopen(io.rname , "r")) == NULL)
			goto rfilerr;
		clearerr(io.rfd);
	}
	if (io.wfd == NULL) {
		/* Open the destination file. */
		if ((io.wfd = fopen(io.wname , "w")) == NULL)
			goto wfilerr;
		clearerr(io.wfd);
	}


	/* Encrypt/decrypt the file */
	/* set the correct file crypt function */
	cr = (*file)(crypt, schedule, (des_cblock *) ivec, mode, &io);

	/* Was there any error during read or write ? */
	if (ferror(io.rfd))
		goto rfilerr;
	if (ferror(io.wfd))
		goto wfilerr;

	if (flags & o_FLAG) {
		if (putivec_file(ivec, ovec_spec) <= 0)
			goto noovec;
		null_string(ovec_spec);
		free(ovec_spec);
	}

	/* No check is neccessary here, just close */
	(void) fclose(io.rfd);
	io.rfd = NULL;

	/* This check is neccessary when dealing with AFS. */
	if (fclose(io.wfd) == EOF) {
		io.wfd = NULL;
		goto wfilerr;
	} 
	io.wfd = NULL;

	/* Was the encrypted file corrupt ? */
	if (cr)
		goto corrupt;

	exit(0);

	/* Error handling section */
usage:
	(void) fprintf(stderr, "Usage: %s -e|-d|-c -h [-b compat] [-n core] [-v file|-i ivec] [-o file] [-f file|-k key [-k key ...]] [-m mode] [-a] [infile [outfile]]\n", prog);
	exit(1);

memalloc:
	fputs(prog, stderr);
	perror(": Could not allocate memory, ");
	exit(1);

rfilerr:
	(void) fprintf(stderr, "%s: Open/read error on \"%s\"", prog, io.rname);
	perror(", ");
	goto close_file;

wfilerr:
	(void) fprintf(stderr, "%s: Open/read error on \"%s\"", prog, io.wname);
	perror(", ");
	goto close_file;

weakkey:
	(void) fprintf(stderr, "%s: The key generated is weak\n", prog);
	exit(1);

nocore:
	(void) fprintf(stderr,
#ifdef DES_CORE
		       (!core_name) ?
		       		"%s: Unknown core algorithm in environment variable DES_CORE\n" :
#endif /* DES_CORE */
		       		"%s: No core algorithm \"%s\" available.\n",
		       prog, core_name);
	if (flags & n_FLAG)
		free(core_name);
	exit(1);

nomode:
	(void) fprintf(stderr,
#ifdef DES_MODE
		       (!mode_name) ?
		       		"%s: Unknown mode in environment variable DES_MODE\n" :
#endif /* DES_MODE */
				"%s: No crypt mode \"%s\" available.\n",
		       prog, mode_name);
	if (flags & m_FLAG)
		free(mode_name);
	exit(1);

nocompat:
	(void) fprintf(stderr,
#ifdef DES_COMPATIBLE
		       (!compat_name) ?
		       		"%s: Unknown compatible mode in environment variable DES_COMPATIBLE\n" :
#endif /* DES_COMPATIBLE */
				"%s: No compatibility mode \"%s\" found.\n",
		       prog, compat_name);
	if (flags & b_FLAG)
		free(compat_name);
	exit(1);

nokey:
	(void) fprintf(stderr, "%s: Can not obtain key\n", prog);
	exit(1);

noivec:
	(void) fprintf(stderr, "%s: Can not obtain ivec\n", prog);
	exit(1);

noovec:
	(void) fprintf(stderr, "%s: Can not store final ivec\n", prog);
	exit(1);

corrupt:
	(void) fprintf(stderr, "%s: Encrypted file \"%s\" is corrupt\n", prog, io.rname);
	if (!(flags & b_FLAG))
		(void) fprintf(stderr, "%s: Try using the `-b compat' option\n", prog);
	exit(1);

close_file:
	if (io.rfd)
		(void) fclose(io.rfd);
	if (io.wfd)
		(void) fclose(io.wfd);
	exit(1);
}
