/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<des.h>
#include	"mode.h"
#include	"pad.h"
#include	"config.h"
#include	"version.h"


#define BUF_SIZE	8192


/*
 * This routine does the encryption/decryption job without padding.
 */

int	crypt_file_plain(
#ifdef __STDC__
	crypt_mode		*crypt,
	des_key_schedule	schedule[],
	des_cblock		*ivec,
	int			mode,
	io_mode			*io)
#else
	crypt, schedule, ivec, mode, io)
crypt_mode		*crypt;
des_key_schedule	schedule[];
des_cblock		*ivec;
int			mode;
io_mode			*io;
#endif
{
	register int	n;
	char		buf[BUF_SIZE];


	/* Do the encryption on compleat blocks */
	while ((n = fread(buf, sizeof(*buf), BUF_SIZE, io->rfd)) > 0) {

		(*crypt->func)((des_cblock *) buf, (des_cblock *) buf,
				n, schedule, ivec, mode); 
		
		(void) fwrite(buf, sizeof(*buf), n, io->wfd);
		if (ferror(io->wfd))
			return 1;
	}

	return 0;
}


int	crypt_file_padding(
#ifdef __STDC__
	struct crypt_mode	*crypt,
	des_key_schedule	schedule[],
	des_cblock		*ivec,
	int			mode,
	io_mode			*io)
#else
	crypt, schedule, ivec, mode, io)
struct crypt_mode	*crypt;
des_key_schedule	schedule[];
des_cblock		*ivec;
int			mode;
io_mode			*io;
#endif
{
	register int	nr, nw;
	char		ibuf[BUF_SIZE + DES_BLOCK_BYTES];
	char		obuf[BUF_SIZE];


	if (mode == DES_ENCRYPT) {

		/* Do the encryption on compleat blocks */
		while ((nr = fread(ibuf, sizeof(*ibuf), BUF_SIZE, io->rfd)) ==
			BUF_SIZE) {

			(*crypt->func)((des_cblock *) ibuf, (des_cblock *) obuf,
				       nr, schedule, ivec, DES_ENCRYPT); 
		
			(void) (*io->write)(obuf, sizeof(*obuf), nr, io->wfd);
			if (ferror(io->wfd))
				return 1;
		}

		nw = (*pad_data)(ibuf, nr, DES_ENCRYPT);

		(*crypt->func)((des_cblock *) ibuf, (des_cblock *) obuf, nw,
			       schedule, ivec, DES_ENCRYPT); 

		(void) (*io->write)(obuf, sizeof(*obuf), nw, io->wfd);

	} else {

		/* Do the decryption on the source file */

		/* Read the first block, return with error if the file	*/
		/* has 0 size.						*/
		if (!(nw = nr = (*io->read)(ibuf, sizeof(*ibuf), BUF_SIZE,
		    io->rfd)))
			return 1;

		/* Decrypt the the current input buffer into the output	*/
		/* buffer.						*/
		(void) (*crypt->func)((des_cblock *) ibuf, (des_cblock *) obuf,
				      nr, schedule, ivec, DES_DECRYPT); 

		/* Read until end of file is found */
		while ((nr = (*io->read)(ibuf, sizeof(*ibuf), BUF_SIZE, io->rfd))
			> 0) {

			/* Write the decrypted contentse of the		*/
			/* previous buffer.				*/
			(void) fwrite(obuf, sizeof(*obuf), nw, io->wfd);
			if (ferror(io->wfd))
				return 0;

			nw = nr;

			/* Decrypt the the current input buffer into	*/
			/* the output buffer.				*/
			(void) (*crypt->func)((des_cblock *) ibuf,
					      (des_cblock *) obuf, nr, schedule,
					      ivec, DES_DECRYPT); 

		}

		nw = (*pad_data)(obuf, nw, DES_DECRYPT);

		/* If the padding information was corrupt !! */
		if (nw < 0)
			return 1;

		/* Write the last output buffer with padding		*/
		/* information removed.					*/
		(void) fwrite(obuf, sizeof(*obuf), nw, io->wfd);

	}

	return 0;
}

/*
 * Compute a 64-bit cryptographic checksum on the file.
 */

int	crypt_file_checksum(
#ifdef __STDC__
	struct crypt_mode	*crypt,
	des_key_schedule	schedule[],
	des_cblock		*ivec,
	int			mode,
	io_mode			*io)
#else
	crypt, schedule, ivec, mode, io)
struct crypt_mode	*crypt;
des_key_schedule	schedule[];
des_cblock		*ivec;
int			mode;
io_mode			*io;
#endif
{
	register int	n;
	char		buf[BUF_SIZE + DES_BLOCK_BYTES];
	des_cblock 	sum;


	while ((n = fread(buf, sizeof(*buf), BUF_SIZE, io->rfd)) > 0)
		(void) (*((cksum_func) crypt->func))((des_cblock *) buf,
						     (des_cblock *) sum,
						     n, schedule[0], ivec);

	(void) (*io->write)((char *) sum, sizeof(*sum), sizeof(sum), io->wfd);

	return 0;
}
