/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */


#define KEY_HEX_FLAG	0x01	/* The keys are hexadecimal numbers.	    */
#define KEY_STRING_FLAG	0x02	/* The keys are in `key_spec'.		    */
#define KEY_FILE_FLAG	0x04	/* The keys are in the file `key_spec[0].   */
#define KEY_VERIFY_FLAG	0x08	/* Verify & prompt for keys.		    */


/*
 * getkey_file
 *
 *	This routine reads multiple keys from `file'.
 *
 *	`getkey_file' returns number of keys read. -1 indicates an i/o error.
 *
 */

extern int	getkey_file(
#ifdef __STDC__
	des_cblock	key[],
	char		*file,
	int		no_keys,
	int		flags
#endif
);


/*
 * getkey_env
 *
 *	This routine fetches multiple keys from the environment.
 *
 *	`getkey_env' returns number of keys read. -1 indicates that the
 *	specified number of keys could not be obtained.
 *
 */

extern int	getkey_env(
#ifdef __STDC__
	des_cblock	key[],
	int		no_keys
#endif
);


/*
 * getkey_prompt
 *
 *	This routine prompts for multiple keys. The keys found are returned
 *	through `key'.
 *
 *	`getkey_prompt' returns number of keys read. -1 indicates an internal
 *	error.
 *
 */

extern int	getkey_prompt(
#ifdef __STDC__
	des_cblock	key[],
	int		no_keys,
	int		flags
#endif
);


/*
 * getkey
 *
 *	This routine reads multiple keys from a file, argument or prompts for
 *	them. The method to get the key is selected through `flags'.
 *	The keys found are returned through `key'.
 *
 *	`getkey' returns number of keys read. -1 indicates an internal error.
 *
 */

extern int	getkey(
#ifdef __STDC__
	des_cblock	key[],
	char		*key_spec[],
	int		no_keys,
	int		flags
#endif
);
