/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<des.h>
#include	<stdio.h>
#include	"pad.h"
#include	"config.h"
#include	"version.h"


pad_func	pad_data = def_pad_data;

/*
 * This a the dwefault padding method.
 */

int	def_pad_data(
#ifdef __SDTC__
	char	buf[],
	int	n,
	int	mode)
#else
	buf, n, mode)
char	buf[];
int	n;
int	mode;
#endif
{
	register int		i, nw;
	register unsigned char	pad;
	des_cblock		pbuf;


	if (mode == DES_ENCRYPT) {
		/* The last section handles padding to ensure that the	*/
		/* encryption is made on compleat eight byte block(s).	*/
		/* The last block will always contain 0 .. 7 bytes of	*/
		/* data, and the last byte contains a number indicating	*/
		/* how may bytes (0 .. 7) that are use for actual data.	*/
		/* Any remaining bits between data bits and the last is */
		/* padded with random bits.				*/

		pad = (unsigned char) (n % DES_BLOCK_BYTES);
		nw = n + (DES_BLOCK_BYTES - (int) pad);

		(void) des_random_cblock((des_cblock *) pbuf);
		pbuf[DES_BLOCK_BYTES - 1] &= ((~(DES_BLOCK_BYTES - 1)) & 0xff);
		pbuf[DES_BLOCK_BYTES - 1] |= pad;
		for (i = pad; i < DES_BLOCK_BYTES; i++)
			buf[i + (n - pad)] = (char) pbuf[i];
	} else {
		/* The last buffer contains padding information that	*/
		/* has to be removed. The buffer must contain at least	*/
		/* on block and be a multiple of block.			*/

		if (!n || n % DES_BLOCK_BYTES)
			return -1;

		/* The last byte in the block contains padding	*/
		/* infomration. Remove the padding bytes and	*/
		/* the padding info.				*/

		pad = (unsigned char) (buf[n - 1] & (DES_BLOCK_BYTES - 1));
		nw = n - (DES_BLOCK_BYTES - (int) pad);
	}

	return nw;
}


/*
 * This a the padding mechanism used by SUN. it is identical to the
 * default mechanism except that the high 5 bits in the last byte
 * (contaning the padding information) is always zero.
 */

int	sun_pad_data(
#ifdef __SDTC__
	char	buf[],
	int	n,
	int	mode)
#else
	buf, n, mode)
char	buf[];
int	n;
int	mode;
#endif
{
	register int		i, nw;
	register unsigned char	pad;
	des_cblock		pbuf;


	if (mode == DES_ENCRYPT) {
		pad = (unsigned char) (n % DES_BLOCK_BYTES);
		nw = n + (DES_BLOCK_BYTES - (int) pad);

		(void) des_random_cblock((des_cblock *) pbuf);
		pbuf[DES_BLOCK_BYTES - 1] = pad;
		for (i = pad; i < DES_BLOCK_BYTES; i++)
			buf[i + (n - pad)] = (char) pbuf[i];
	} else {
		/* The buffer length must be a multiple of one or more	*/
		/* DES_BLOCK_BYTES.					*/
		if (!n || n % DES_BLOCK_BYTES)
			return -1;

		pad = (unsigned char) buf[n - 1];
		if (pad >= DES_BLOCK_BYTES)
			return -1;
		nw = n - (DES_BLOCK_BYTES - (int) pad);
	}

	return nw;
}
