/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<stdio.h>
#include	<string.h>
#include	<des.h>
#include	"config.h"
#include	"data.h"


static
#ifdef __SDTC__
	const
#endif
		char	*fmt = "%02x%02x%02x%02x%02x%02x%02x%02x";



static int	read_hex(
#ifdef __SDTC__
	char		*str,
	des_cblock	block)
#else
	str, block)
char		*str;
des_cblock	block;
#endif
{
	register int	i;
	unsigned int	x[DES_BLOCK_BYTES];

	
	if (sscanf(str, fmt, &x[0], &x[1], &x[2], &x[3], &x[4], &x[5], &x[6], &x[7]) != DES_BLOCK_BYTES)
		return -1;
	for (i = 0; i < DES_BLOCK_BYTES; i++)
		block[i] = (unsigned char) x[i];
	return DES_BLOCK_BYTES * 2;
}


void	print_block(
#ifdef __SDTC__
	FILE		*fd,
	des_cblock	block)
#else
	fd, block)
FILE		*fd;
des_cblock	block;
#endif
{
	fprintf(fd, fmt, (int) block[0],
			 (int) block[1],
			 (int) block[2],
			 (int) block[3],
			 (int) block[4],
			 (int) block[5],
			 (int) block[6],
			 (int) block[7]);
}


int	cmp_block(
#ifdef __SDTC__
	des_cblock	block1,
	des_cblock	block2)
#else
	block1, block2)
des_cblock	block1;
des_cblock	block2;
#endif
{
	return	block1[0] == block2[0] &&
		block1[1] == block2[1] &&
		block1[2] == block2[2] &&
		block1[3] == block2[3] &&
		block1[4] == block2[4] &&
		block1[5] == block2[5] &&
		block1[6] == block2[6] &&
		block1[7] == block2[7];
}


data_t	*read_data(
#ifdef __STDC__
	FILE	*fd)
#else
	fd)
FILE	*fd;
#endif
{
	register int	n;
	register char	*bp;
	char		buf[256];
	static data_t	data;


	while (fgets(buf, sizeof(buf), fd)) {
		if ((buf[0] != 'E' && buf[0] != 'D') || (buf[1] != ' ' && buf[1] != '\t'))
			continue;
		bp = buf;
		data.mode = (*bp++ == 'E') ? DES_ENCRYPT : DES_DECRYPT;

		for (; *bp == ' ' || *bp == '\t'; bp++);
		if ((n = read_hex(bp, data.key)) < 0)
			continue;
		bp += n;

		for (; *bp == ' ' || *bp == '\t'; bp++);
		if ((n = read_hex(bp, data.in)) < 0)
			continue;
		bp += n;

		for (; *bp == ' ' || *bp == '\t'; bp++);
		if ((n = read_hex(bp, data.out)) < 0)
			continue;
		bp += n;

		for (; *bp == ' ' || *bp == '\t'; bp++);
		if ((n = read_hex(bp, data.ivec)) < 0)
			continue;

		return &data;;
	}

	return (data_t *) 0;
}
