/* ====================================================================
 * Copyright (c) 1998 Ralf S. Engelschall. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * 4. The names "mod_ssl" must not be used to endorse or promote
 *    products derived from this software without prior written
 *    permission. For written permission, please contact
 *    rse@engelschall.com.
 *
 * 5. Products derived from this software may not be called "mod_ssl"
 *    nor may "mod_ssl" appear in their names without prior
 *    written permission of Ralf S. Engelschall.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by 
 *     Ralf S. Engelschall <rse@engelschall.com> for use in the
 *     mod_ssl project (http://www.engelschall.com/sw/mod_ssl/)."
 *
 * THIS SOFTWARE IS PROVIDED BY RALF S. ENGELSCHALL ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RALF S. ENGELSCHALL OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes software developed by Ben Laurie
 * for use in the Apache-SSL HTTP server project.
 */

/* ====================================================================
 * Copyright (c) 1995, 1996, 1997, 1998 Ben Laurie.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Ben Laurie
 *    for use in the Apache-SSL HTTP server project."
 *
 * 4. The name "Apache-SSL Server" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Ben Laurie
 *    for use in the Apache-SSL HTTP server project."
 *
 * THIS SOFTWARE IS PROVIDED BY BEN LAURIE ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL BEN LAURIE OR
 * HIS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */

/*                      _             _ 
**  _ __ ___   ___   __| |    ___ ___| |  
** | '_ ` _ \ / _ \ / _` |   / __/ __| |  
** | | | | | | (_) | (_| |   \__ \__ \ | mod_ssl - Apache Interface to SSLeay
** |_| |_| |_|\___/ \__,_|___|___/___/_| http://www.engelschall.com/sw/mod_ssl/
**                      |_____|         
*/


#include "mod_ssl.h"


/*  _________________________________________________________________
**
**  Global data
**  _________________________________________________________________
*/

int         ssl_g_nInitCount             = 0;
conn_rec   *ssl_g_pCurrentConnection     = NULL;
server_rec *ssl_g_pServer                = NULL;
pool       *ssl_g_pPool                  = NULL;
char       *ssl_g_szPassPhrase           = NULL;
BOOL        ssl_g_bPassPhrase            = FALSE;
RSA        *ssl_g_pRSATmpKey             = NULL;
int         ssl_g_nSessionCacheMode      = SSL_SCMODE_UNSET;
char       *ssl_g_szSessionCacheDataFile = NULL;
int         ssl_g_nMutexMode             = SSL_MUTEXMODE_UNSET;
char       *ssl_g_szMutexFile            = NULL;
int         ssl_g_nMutexFD               = -1;
int         ssl_g_nMutexSEMID            = -1;


/*  _________________________________________________________________
**
**  Apache API glue structures
**  _________________________________________________________________
*/

/* 
 *  the table of configuration directives we provide 
 */
static command_rec ssl_cmds[] = {
    /*
     * Per-Server Configuration Directives (main server only)
     */

    { "SSLMutex", ssl_cmd_SSLMutex,
      NULL, RSRC_CONF, TAKE1,
      "SSL lock for handling internal mutual exclusions (`none', `file:/path/to/file')" },

    { "SSLPassPhraseDialog", ssl_cmd_SSLPassPhraseDialog,
      NULL, RSRC_CONF, TAKE1,
      "SSL dialog mechanism for the pass phrase query (`builtin', `filter:/path/to/filter'" },
    { "SSLPassPhraseCaching", ssl_cmd_SSLPassPhraseCaching,
      NULL, RSRC_CONF, FLAG,
      "SSL switch for memory caching the pass phrase for restarts (`on', `off')" },

    /*
     * Per-Server Configuration Directives (main and virtual servers)
     */

    { "SSLEngine", ssl_cmd_SSLEngine,
      NULL, RSRC_CONF, FLAG,
      "SSL switch for the protocol engine (`on', `off')" },

    { "SSLCipherSuite", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szCipherSuite), RSRC_CONF, TAKE1,
      "Colon-delimited list of permitted SSL Ciphers" },

    { "SSLCertificateFile", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szCertificateFile), RSRC_CONF, TAKE1,
      "SSL Server Certificate file (PEM encoded)" },
    { "SSLCertificateKeyFile", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szKeyFile), RSRC_CONF, TAKE1,
      "SSL Server Certificate Private Key file (PEM encoded)" },

    { "SSLCACertificatePath", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szCACertificatePath), RSRC_CONF, TAKE1,
      "SSL CA Certificate path" },
    { "SSLCACertificateFile", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szCACertificateFile), RSRC_CONF, TAKE1,
      "SSL CA Certificate file (PEM encoded)" },
    { "SSLCACertificateReqFile", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szCACertificateReqFile), RSRC_CONF, TAKE1,
      "SSL CA Certificate SSLv3-Request file (PEM encoded)" },

    { "SSLVerifyClient", ssl_cmd_SSLVerifyClient,
      NULL, RSRC_CONF, TAKE1,
      "SSL Client verify type (`none', `optional', `require', `optional_no_ca'" },
    { "SSLVerifyDepth", ssl_cmd_PolySetSlotInt,
      (void *)XtOffsetOf(SSLConfigRec, nVerifyDepth), RSRC_CONF, TAKE1,
      "SSL Client verify depth (default 0)" },

    { "SSLSessionCache", ssl_cmd_SSLSessionCache,
      NULL, RSRC_CONF, TAKE1,
      "SSL Session Cache storage mode (`none', `dbm:/path/to/file')" },
    { "SSLSessionCacheTimeout", ssl_cmd_PolySetSlotInt,
      (void *)XtOffsetOf(SSLConfigRec, nSessionCacheTimeout), RSRC_CONF, TAKE1,
      "SSL Session Cache object lifetime in seconds" },

    { "SSLFakeBasicAuth", ssl_cmd_PolySetSlotTrue,
      (void *)XtOffsetOf(SSLConfigRec, bFakeBasicAuth), RSRC_CONF, NO_ARGS,
      "Translate SSL client X509 certificate into a standard Basic Auth user name" },

    { "SSLLog", ssl_cmd_PolySetSlotString,
      (void *)XtOffsetOf(SSLConfigRec, szLogFile), RSRC_CONF, TAKE1,
      "SSL logfile for SSL-related messages" },
    { "SSLLogLevel", ssl_cmd_SSLLogLevel,
      NULL, RSRC_CONF, TAKE1,
      "SSL logfile verbosity level (none|error|warn|info|debug)" },

    /*
     * Per-Directory Configuration Directives
     */

    { "SSLRequireSSL", ssl_cmd_SSLRequireSSL, 
      NULL, OR_FILEINFO, NO_ARGS,
      "Require the SSL protocol for the per-directory context" },
    { "SSLRequireCipher", ssl_cmd_SSLRequireCipher,
      NULL, OR_FILEINFO, ITERATE,
      "Add a SSL Cipher to the per-directory context list of required ciphers" },
    { "SSLBanCipher", ssl_cmd_SSLBanCipher, 
      NULL, OR_FILEINFO, ITERATE,
      "Add a SSL Cipher to the per-directory context list of banned ciphers" },

    { NULL },
};

/* 
 *  the main Apache API config structure 
 */
module MODULE_VAR_EXPORT ssl_module = {
    STANDARD_MODULE_STUFF,
    ssl_init_Module,          /* module initializer                  */
    ssl_config_perdir_create, /* create per-dir    config structures */
    ssl_config_perdir_merge,  /* merge  per-dir    config structures */
    ssl_config_server_create, /* create per-server config structures */
    ssl_config_server_merge,  /* merge  per-server config structures */
    ssl_cmds,                 /* table of config file commands       */
    NULL,                     /* [#8] MIME-typed-dispatched handlers */
    NULL,                     /* [#1] URI to filename translation    */
    ssl_hook_Auth,            /* [#4] validate user id from request  */
    NULL,                     /* [#5] check if the user is ok _here_ */
    ssl_hook_Access,          /* [#2] check access by host address   */
    NULL,                     /* [#6] determine MIME type            */
    ssl_hook_Fixup,           /* [#7] pre-run fixups                 */
    NULL,                     /* [#9] log a transaction              */
    NULL,                     /* [#3] header parser                  */
    ssl_init_Child,           /* child_init                          */ 
    NULL,                     /* child_exit                          */ 
    NULL                      /* [#0] post read-request              */ 
};


