/*  Hey Emacs, please switch to -*-C-*-
------------

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.
*/

#include <stdlib.h>

#include "pgplib.h"
#include "pgp_m.h"

void
free_uid(PGPuserid_t	*uid)
{
    if ( uid == NULL)
	return;
    if ( uid->name != NULL )
	free(uid->name);
}

/*
 * Return the length of the buffer, or 0 on failure.
 */

int
uid2buf(PGPuserid_t	*uid,
	u_char		**buf)
{
    int		len;
    u_char	*p;

    len = (u_char) strlen(uid->name);
    if ( len > 255 )
	return(0);
    p = malloc(len+2);
    if ( p == NULL ) {
	fprintf(stderr, "Out of memory\n");
	return(0);
    }
    p[0] = CTB_USERID;
    p[1] = (u_char) len;
    memcpy(p+2, uid->name, len);
    
    *buf = p;
    return(len+2);
}
    
/*
 * Convert a buffer into a C-string (within a struct).  We can do
 * some verification.  If there is an error, we return -1 if not, we
 * return the amount of bufferspace used by us.
 */
int
buf2userid(u_char	*buf,
	   int 		length, 
	   PGPuserid_t 	*uid)
{
    u_char	*p;
    int		len;
    /* scratch */
    int		i;

    if ( buf == NULL || length < 3 || uid == NULL )
	return(-1);

    len = packet_length(buf);
    i  = (int)buf[1];
    if ( i != len-2 )
	return(-1);
    p = malloc(len-1);
    if ( p == NULL ) {
	fprintf(stderr, "Out of memory\n");
	return(-1);
    }
    
    memcpy(p, buf+2, len - 2);
    p[len-2] = NULL;
    
    uid->name = p;

    return(len);
}
    

