


ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



NAME
     elmalias - expand and display Elm address aliases

SYNOPSIS
     elmalias [ -adenrsuvV ] [ -f format ] [ name  ... ]

     $_l_i_b/prlong [ options ... ] < _f_i_l_e

DESCRIPTION
     _E_l_m_a_l_i_a_s allows you to examine  information  about  aliases.
     The  alias databases are consulted for each _n_a_m_e on the com-
     mand line, and the alias value is displayed, one  value  per
     line  of  output.   If _n_a_m_e is not a known alias, then it is
     displayed unchanged.  If no _n_a_m_e is  given  on  the  command
     line  then  all alias values in the databases are displayed.
     All of these actions are default behaviors that may be modi-
     fied  by command line options.  There are two possible alias
     databases,  a   user-specific   alias   file   (usually   in
     $_H_O_M_E/._e_l_m/_a_l_i_a_s_e_s) and a system-wide alias file (usually in
     $_l_i_b/_a_l_i_a_s_e_s).  By default both files  are  searched,  first
     the user-specific file and then the system-wide file.  If an
     alias file does not exist then _e_l_m_a_l_i_a_s silently ignores  it
     and  continues on.  The -s and -u command line options (dis-
     cussed shortly) can restrict what files are files  searched.
     There  are  two  types  of aliases, Person aliases and Group
     aliases.  A Person alias expands to  an  individual  address
     and  a  Group  alias  contains  a list of addresses, some of
     which may be aliases.  By  default,  _e_l_m_a_l_i_a_s  displays  the
     defined  value of an alias, regardless of type.  The -e com-
     mand line option (discussed shortly) fully expands out Group
     aliases.    The   default   output   produced  is  just  the
     ``Address'' information for each _n_a_m_e on the  command  line.
     A  number of command line options (discussed shortly) may be
     used to select different output  information  or  specify  a
     format of your choosing.  The following information is main-
     tained in the alias databases, and may be  accessed  by  the
     _e_l_m_a_l_i_a_s utility:

          o+ Alias (the alias name)
          o+ Last Name
          o+ Name (the user's full name)
          o+ Comment (not displayed in mail headers)
          o+ Address (the alias value)
          o+ Type (Person, Group, or Unknown)

     When the _n_a_m_e specified on the command line is not  a  known
     alias,  both  the ``Alias'' and ``Address'' information will
     display as the _n_a_m_e, the ``Type'' information  will  display
     as  ``Unknown'',  and  all  other  items will be blank.  The
     available command line options are:

     -a   Selects an alternative output  format.   The  ``Alias''



USENET Community TrustLast change: Elm Version 2.4                 1






ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



          information  is  displayed in addition to and preceding
          the usual ``Address'' information.

     -d   Turns debugging on. Has no effect unless  _e_l_m_a_l_i_a_s  was
          compiled with debugging enabled.

     -e   Tells _e_l_m_a_l_i_a_s to fully  expand  group  aliases.   This
          option  can  be  used  only when _n_a_m_es are given on the
          command line.

     -f   The output produced will be in  the  specified  _f_o_r_m_a_t.
          Format specifications will be discussed shortly.

     -n   Selects an alternative  output  format.   The  ``Name''
          information,  if it exists, is displayed in addition to
          and following the usual ``Address''  information.   The
          ``Name'' will be enclosed in parenthesis.

     -r   If a specified _n_a_m_e does  not  correspond  to  a  known
          alias  then  _e_l_m_a_l_i_a_s  will  display a message and exit
          with a nonzero status.

     -s   Normally _e_l_m_a_l_i_a_s examines both the  user-specific  and
          system-wide  alias  files.   This  option requests that
          _e_l_m_a_l_i_a_s use the system-wide alias file, and unless the
          -u  option  is  also  specified the user-specific alias
          file will be ignored.

     -u   Normally _e_l_m_a_l_i_a_s examines both the  user-specific  and
          system-wide  alias  files.   This  option requests that
          _e_l_m_a_l_i_a_s use the user-specific alias file,  and  unless
          the  -s  option is also specified the system-wide alias
          file will be ignored.

     -v   Selects a verbose output format.   Both  the  ``Alias''
          and the ``Name'' information will be displayed in addi-
          tion to the  ``Address''  information.   The  ``Alias''
          information  will  precede the ``Address'' information,
          and  the  ``Name''  information  will  be  enclosed  in
          parenthesis  and  follow  it.   If there is no ``Name''
          information for this alias then  that  portion  of  the
          output will be ignored.

     -V   Selects  a  very  verbose,  multi-line  output  format.
          Displays  all  available  information  on aliases.  The
          output produced by _e_l_m_a_l_i_a_s is fully customizable  with
          the -f option.  The _f_o_r_m_a_t string uses a syntax similar
          to _d_a_t_e(_1) (System V version) and _p_r_i_n_t_f(_3).  The  fol-
          lowing field descriptors may be used in _f_o_r_m_a_t specifi-
          cations:

               %a   Alias (the alias name)



USENET Community TrustLast change: Elm Version 2.4                 2






ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



               %l   Last Name
               %n   Name (the user's full name)
               %c   Comment (not displayed in mail headers)
               %v   Address (the alias value)
               %t   Type (Person, Group, or Unknown)

          Field widths in a [-][_m][._n] format (again, similar  to
          _p_r_i_n_t_f(_3))  may  also be used.  For example, "%-20.20a"
          means print the ``Alias'' information left justified in
          a  field  twenty  characters long, with the value trun-
          cated to  twenty  characters.   The  following  special
          character  sequences  are  also  recognized  in  format
          specifications:

               \b   A backspace.
               \f   A formfeed.
               \n   A newline.
               \r   A return.
               \t   A tab.
               \_c   Literal character ``_c''.

          There  is  a  very  simplistic  conditional  evaluation
          mechanism  that  may  be used in format specifications.
          The conditional text should be surrounded  by  question
          marks, and a single character that specifies the condi-
          tion immediately follows the first question mark.   The
          condition  characters  correspond  to  the  ``%'' field
          specifier characters, and the condition is true if  the
          corresponding   alias   information   is   defined  and
          nonempty.  For example, if  you  want  to  display  the
          ``Name''  information  surrounded  by  parenthesis, but
          omit it if the information is not  available,  you  may
          use  ``?n(%n)?'' in the format specification.  The com-
          mand line switches that select  an  alternative  format
          correspond to the following format specifiers.

               _d_e_f_a_u_l_t   "%v"
               -a   "%-20.20a %v"
               -n   "%v?n (%n)?"
               -v   "%-20.20a %v?n (%n)?"
               -V   "Alias:\t\t%a\n\
                      Address:\t%v\n\
                      Type:\t\t%t\n\
                    ?n  Name:\t\t%n\n?\
                    ?l  Last Name:\t%l\n?\
                    ?c  Comment:\t%c\n?"

          The _p_r_l_o_n_g utility formats long amounts of data,  fold-
          ing  across  multiple  lines.  It is useful to reformat
          output of _e_l_m_a_l_i_a_s.  _P_r_l_o_n_g reads data from  its  stan-
          dard  input,  one line at a time, and tries to place as
          much information as possible on each  output  line.   A



USENET Community TrustLast change: Elm Version 2.4                 3






ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



          field  seperator,  by default a single space, seperates
          each input record in the output  lines.   Every  output
          line  is  preceded  by  a leader field.  By default the
          leader of the first output line is an empty string, and
          the  leader for all subsequent output lines is a single
          tab.  _p_r_l_o_n_g will never split an input record.   If  an
          input record exceeds the maximum output line length, it
          will appear unmodified on an output line all by itself.
          The  following options may be used to modify the _p_r_l_o_n_g
          behavior.

     -w _w_i_d_t_h    Constrains output  lines  to  _w_i_d_t_h  columns  in
                 length (not counting an appended newline charac-
                 ter).  The default is  78  columns.   The  width
                 calculation  assumes  that  tabstops occur every
                 eight spaces.

     -f _s_t_r_i_n_g   Seperates each input record with  the  indicated
                 _s_t_r_i_n_g   when  displayed  to  the  output.   The
                 default is a single space.

     -1 _s_t_r_i_n_g   Specifies the leader _s_t_r_i_n_g used for  the  first
                 line  of  output.   (This  option  is  the digit
                 ``one''.) The default is an empty string.

     -l _s_t_r_i_n_g   Specifies the leader _s_t_r_i_n_g for  all  subsequent
                 lines  of  output.  (This option is a lower-case
                 ``ell''.) The default is a single tab.

EXAMPLES
     Consider an _a_l_i_a_s_e_s._t_e_x_t file that contains:

          friends = List of Friends = tom, dick, harry
          tom = Tom Smith = sleepy!tom
          dick = Dick Jones = dopey!dick
          harry = = grumpy!harry

     Below are shown some example commands and  the  output  pro-
     duced.

          $ _e_l_m_a_l_i_a_s _f_r_i_e_n_d_s
          tom,dick,harry
          $ _e_l_m_a_l_i_a_s _m_i_k_e
          mike
          $ _e_l_m_a_l_i_a_s -_r _m_i_k_e
          elmalias: "mike" is not a known alias
          $ _e_l_m_a_l_i_a_s -_n _f_r_i_e_n_d_s
          tom,dick,harry (List of Friends)
          $ _e_l_m_a_l_i_a_s -_a _f_r_i_e_n_d_s
          friends              tom,dick,harry
          $ _e_l_m_a_l_i_a_s -_V _f_r_i_e_n_d_s
          Alias:          friends



USENET Community TrustLast change: Elm Version 2.4                 4






ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



            Address:      tom,dick,harry
            Type:         Group
            Name:         List of Friends
            Last Name:    List of Friends
          $ _e_l_m_a_l_i_a_s -_e _f_r_i_e_n_d_s
          tom@sleepy.acme.com
          dick@dopey.acme.com
          harry@grumpy.acme.com
          $ _e_l_m_a_l_i_a_s -_v_e _f_r_i_e_n_d_s
          tom                  tom@sleepy.acme.com (Tom Smith)
          dick                 dick@dopey.acme.com (Dick Jones)
          harry                harry@grumpy.acme.com
          $ _e_l_m_a_l_i_a_s -_f "_a_l_i_a_s %_a _i_s \"%_v\" ?_n(%_n)?" -_e _f_r_i_e_n_d_s
          alias tom is "tom@sleepy.acme.com" (Tom Smith)
          alias dick is "dick@dopey.acme.com" (Dick Jones)
          alias harry is "harry@grumpy.acme.com"
          $ _e_l_m_a_l_i_a_s -_e_n _f_r_i_e_n_d_s | /_u_s_r/_l_i_b/_e_l_m/_p_r_l_o_n_g -_w_4_0
          tom@sleepy.acme.com (Tom Smith)
                  dick@dopey.acme.com (Dick Jones)
                  harry@grumpy.acme.com
          $ _e_l_m_a_l_i_a_s -_e_n _f_r_i_e_n_d_s | /_u_s_r/_l_i_b/_e_l_m/_p_r_l_o_n_g -_1 "_T_o: " -_f ", " -_w_4_0
          To: tom@sleepy.acme.com (Tom Smith),
                  dick@dopey.acme.com (Dick Jones),
                  harry@grumpy.acme.com

     The _c_h_e_c_k_a_l_i_a_s(1L)  and  _l_i_s_t_a_l_i_a_s(1L)  scripts  distributed
     with  the  Elm  package  provide  further  examples  of  the
     _e_l_m_a_l_i_a_s and _p_r_l_o_n_g utilities.

AUTHOR
     Elm Development Group

SEE ALSO
     checkalias(1L), elm(1L), listalias(1L), newalias(1L)

BUGS
     There is no centralized, comprehensive interface to the  Elm
     2.4  alias  system,  so  every program in the Elm suite that
     uses aliases implements its own interfaces.   It's  possible
     for  inconsistencies  to creep in between what _e_l_m_a_l_i_a_s says
     and what some Elm utility  does.   If  you  find  an  incon-
     sistency  please report it to us!  Boy, there sure are a lot
     of command line switches in this thing.  Note that the  pre-
     cedence  of  aliases  is  user  file then system file.  This
     means that a user can 'overload'  an  alias  by  having  one
     defined  in  the  system  file also defined in theirs.  This
     shouldn't turn out to be a problem, but is something for the
     system  administrator to keep in mind when creating the sys-
     tem alias file.

BUG REPORTS TO
     Syd Weinstein  elm@DSI.COM    (dsinc!elm)



USENET Community TrustLast change: Elm Version 2.4                 5






ELMALIAS(1L)      MISC. REFERENCE MANUAL PAGES       ELMALIAS(1L)



COPYRIGHTS
     Copyright 1993 by The USENET Community Trust





















































USENET Community TrustLast change: Elm Version 2.4                 6



