/*		CCI redirect object 
**		=================
*/
#include <stdio.h>
#include "cciServer.h"
#include "list.h"
#include "memStuffForPipSqueeks.h"

#include "HTPlain.h"
#include "HTUtils.h"
#include "HText.h"
#include "HTFile.h"
#include "HTCompressed.h"

extern void MoCCISendOutputToClient();
extern void HTCompressedFileToFile (char *fnam, int compressed);

/*		HTML Object
**		-----------
*/

struct _HTStream {
	CONST HTStreamClass *	isa;

	HTAtom *dataType;
	char fileName[L_tmpnam]; /* name of temp file... kept for unlink()ing*/
	FILE *fp; 
   
        int compressed;
};

/*_________________________________________________________________________
**
**			A C T I O N 	R O U T I N E S
*/

/*	Character handling
**	------------------
*/

PRIVATE void CCI_put_character ARGS2(HTStream *, me, char, c)
{
	fputc(c,me->fp);
}



/*	String handling
**	---------------
**
*/
PRIVATE void CCI_put_string ARGS2(HTStream *, me, CONST char*, s)
{

	fwrite(s,1,strlen(s),me->fp);
}


PRIVATE void CCI_write ARGS3(HTStream *, me, CONST char*, s, int, l)
{
	fwrite(s,1,l,me->fp);
}



/*	Free an HTML object
**	-------------------
**
**	Note that the SGML parsing context is freed, but the created object is not,
**	as it takes on an existence of its own unless explicitly freed.
*/
PRIVATE void CCI_free ARGS1(HTStream *, me)
{
#ifdef DEBUG
printf("CCI_free()\n");
#endif
/*
  if (me->compressed != COMPRESSED_NOT)
    {
      if (TRACE)
        fprintf 
          (stderr, 
           "[CCI_free] OK, we're going to decompress HText\n");
      HTCompressedHText (me->text, me->compressed, 1);
    }

  free(me);
*/
}

/*	End writing
*/

PRIVATE void CCI_end_document ARGS1(HTStream *, me)
{

	fclose(me->fp);
	/* ship it */
	if ( me->compressed != COMPRESSED_NOT)
	  HTCompressedFileToFile (me->fileName, me->compressed);	
	MoCCISendOutputToClient(HTAtom_name(me->dataType),me->fileName);
/*
	unlink(me->fileName);
*/
}

PRIVATE void CCI_handle_interrupt ARGS1(HTStream *, me)
{
	fclose(me->fp);
	unlink(me->fileName);
}



/*		Structured Object Class
**		-----------------------
*/
PUBLIC CONST HTStreamClass CCIout =
{		
	"CCIout",
	CCI_free,
	CCI_end_document,
	CCI_put_character, 	CCI_put_string, CCI_write,
        CCI_handle_interrupt
}; 


/*		New object
**		----------
*/
PUBLIC HTStream* CCIPresent ARGS5(
	HTPresentation *,	pres,
	HTParentAnchor *,	anchor,	
	HTStream *,		sink,
        HTFormat,               format_in,
        int,                    compressed)
{
HTStream* me = (HTStream*)malloc(sizeof(HTStream));

	me->isa = &CCIout;       

	(void) tmpnam(me->fileName);
	if (!(me->fp = fopen(me->fileName,"w"))) {
		/*error, can't open tmp file */
		return(sink);
		}
	me->dataType = pres->rep;
	me->compressed = compressed;

/*
  if (me->compressed == COMPRESSED_NOT)
    HText_appendText(me->text, "<PLAINTEXT>\n");
*/

  return (HTStream*) me;
}
