#ifndef LOOPCONS_H
#define LOOPCONS_H

#ifdef __GNUC__
#pragma interface
#endif

#include <expression.h>

struct LoopConsClosure : public Block {
    LoopConsClosure(Block *outer) : Block(outer) { }
};

struct LoopConsProc : public ProcExpr {
  LoopConsProc(Block *bl) : ProcExpr(bl) { }
  virtual Expression * traverse(struct TraverseData *data);
};

class LoopConsExpr : public Expression {
   public:
    LoopConsProc* proc;
    LoopConsClosure* closure;
    int needs_index; /* > 0 if contains a niladic ? operation */
    int seq_arg_count;
    LoopConsExpr(LoopConsProc *p, LoopConsClosure* cl);
    virtual Expression * traverse(struct TraverseData *data);
    virtual void printon(ostream&) const;
    virtual void eval(void* dst, Type* dstType, DisplayEnv *env);
};

struct IndexExpr : public ExprStdOp {
    IndexExpr() { clear_std_fields(IndexExpr_code); }
    virtual Expression * traverse(struct TraverseData *data);
    virtual void eval(void* dst, Type* dstType, DisplayEnv *env);
    virtual void printon(ostream&) const;
    virtual Expression * quote_words(struct TraverseData *data = NULL);
};

#endif /* not LOOPCONS_H */
