COMMENT |
============================================================================
  
  NOISE.SYS v0.4.1-Beta, /dev/random driver for DOS boxes (16 Jan 96)
  by Robert Rothenburg Walking-Owl.  Portions by Colin Plumb.
  Copyright (C) 1995-1996.  All Rights Reserved.

  This is code for a character device which samples various sources of
  entropy (most based on fast timings between events like keystrokes
  and disk access) and accumulates them in a pool which is mixed using
  a Secure Hash Algorithm transformation.

== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA.

===========================================================================|

__cpu        equ 3  ; 3 for 386, 4 for 486

__sample09   equ 1  ; 1 to sample Int 0x09 (Keyboard ISR)
__sample13   equ 1  ; 1 to sample Int 0x13 (Low-level disk calls)
__sample14   equ 0  ; 1 to sample Int 0x14 (Serial Ports)
; ----- Is it worth sampling the Communications ports? Most programs that
;       use it install their own drivers over and above previous driver

__sample28   equ 1  ; 1 to sample drift or audio card during idle
__sampldrift equ 1  ; 1 to sample clock drift
__samplaudio equ 0  ; sample from audio card

; ----- Note: loading the driver with mouse-sampling enabled before the
;       mouse-driver is enabled will probably cause your system to crash!

__sample08   equ 1  ; 1 to hook to timer and periodically sample non-timer
                    ; sources, enabled by /P option on loading
__samplmouse equ 1  ; sample mouse position changes (req. __sample08)
__sample33   equ 0  ; 1 to sample Int 0x33 (Mouse) /M option.

initseedcnt  equ 20 ; if non-zero, sample keystrokes when /I option given

; --------------------------------------------------------------------------
; ----- Note: these defines for testing only, in order to verify how much
;       entropy is generated by a particular sampling method.
NOHASH       equ 0  ; 1 disables mixing with hash function
NOMIX        equ 0  ; 1 disables mixing of new samples in pool
; --------------------------------------------------------------------------

unknowncmd equ 8003h
BUSY       equ 0200h
DONE       equ 0100h

drvname    equ 'NOISE.SYS'; name of driver
drvver     equ '0.4.1', 225
attribute  equ 1000000000000000b  ; driver attribute word

                include noise.mac

if __cpu lt 3
   .err         ; 386 is min supported CPU for this version
elseif __cpu eq 3
   .386
elseif __cpu eq 4
   .486
endif

; --------------------------------------------------------------------------
_TEXT   segment word public use16 'CODE'
        assume  cs:_TEXT, ds:_TEXT
        org     0
rheader label   dword                   ; /dev/random device header
        dw      uheader, -1             ; device header offset        
        dw      attribute               ; character device
        dw      rstrategy               
        dw      rinterrupt
        db      'RANDOM  '              ; device name

rrh     label   dword                   ; request header pointer
        dd      ?
; --------------------------------------------------------------------------
uheader label   dword                   ; /dev/urandom device header
        dd      -1                      ; device header offset        
        dw      attribute               ; character device
        dw      ustrategy               
        dw      uinterrupt
        db      'URANDOM '              ; device name

urh     label   dword                   ; request header pointer
        dd      ?
; --------------------------------------------------------------------------
; Data used by the driver
index   label   word
        dw      0                       ; where new data is put
bytesavail label word                   ; output queue pointer
  ife NOHASH
        dw      0                 
statesize equ (hashbits/8)              ; 160 bits
state   label   dword                   ; initial SHA chaining variables
        dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h, 0C3D2E1F0h
initstate label dword                   ; initial SHA chaining variables
        dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h, 0C3D2E1F0h
  else
statesize equ rawsize
        dw      rawsize-1
  endif
freshcount label word                   ; total fresh bits in pool
        dw      0
pool    dd      80 dup (?)              ; sampling pool SHA expansion array
; --------------------------------------------------------------------------
rdevicetable label word                 ; /dev/random device table
        dw      rdevok                  ; Initialize driver
        dw      rdevok                  ; Media Check
        dw      rcunknown
        dw      rcunknown
        dw      rdevread                ; Read
        dw      rcunknown               ; Nondestructive Read (Removed 0.3.5)
        dw      devstatus               ; Input Status
        dw      rflushdevice            ; Flush Input Buffers
rMAXCMD equ     ($ - rdevicetable) / 2  ; Maximum allowable command
; --------------------------------------------------------------------------
udevicetable label word                 ; /dev/urandom device table
        dw      initdevice              ; Initialize driver
        dw      devok                   ; Media Check
        dw      cunknown
        dw      cunknown
        dw      devread                 ; Read
        dw      cunknown                ; Nondestructive Read (Removed 0.3.5)
        dw      devok                   ; Input Status
        dw      flushdevice             ; Flush Input Buffers
uMAXCMD equ     ($ - udevicetable) / 2  ; Maximum allowable command
; --------------------------------------------------------------------------
rstrategy       proc    far
                mov     WORD PTR cs:rrh, bx
                mov     WORD PTR cs:rrh+2, es
                ret
rstrategy       endp

ustrategy       proc    far
                mov     WORD PTR cs:urh, bx
                mov     WORD PTR cs:urh+2, es
                ret
ustrategy       endp
; --------------------------------------------------------------------------
rinterrupt      proc    far
                cld
                SaveRegs
                les     di, DWORD PTR rrh
                mov     bl, es:[di].ReqHdr.CmdCode
                xor     bh, bh
                cmp     bx, rMAXCMD
                ja      SHORT rcunknown
                add     bx, bx
                jmp     WORD PTR rdevicetable[bx]
  rcunknown:                           ; ----- Unknown command
                mov     ax, unknowncmd
                jmp     SHORT rfinished
  rdevok:                               ; Everything went Ok
                xor     ax, ax
  rfinished:                            ; Leave the driver
                les     bx, DWORD PTR rrh ; es:[bx] -> response header
                or      ax, DONE    ; set to done code
                mov     es:[bx].ReqHdr.StatusCode, ax
                RestoreRegs
                ret
rinterrupt      endp
; --------------------------------------------------------------------------
uinterrupt      proc    far
                cld
                SaveRegs
                les     di, DWORD PTR urh
                mov     bl, es:[di].ReqHdr.CmdCode
                xor     bh, bh
                cmp     bx, uMAXCMD
                ja      SHORT cunknown
                add     bx, bx
                jmp     WORD PTR udevicetable[bx]
  cunknown:                            ; ----- Unknown command
                mov     ax, unknowncmd
                jmp     SHORT finished
; --------------------------------------------------------------------------
; initdevice routine moved to disposed portion of driver (v0.3.5)

  devok:                                ; Everything went Ok
                xor     ax, ax
  finished:                             ; Leave the driver
                les     bx, DWORD PTR urh ; es:[bx] -> response header
                or      ax, DONE    ; set to done code
                mov     es:[bx].ReqHdr.StatusCode, ax
                RestoreRegs
                ret
uinterrupt      endp
; --------------------------------------------------------------------------
doneread        proc    near            ; Read operation completed
                mov     bytesavail, 0   ; throw away remaining bytes
                jmp     SHORT devok
doneread        endp
  ife NOHASH
; --------------------------------------------------------------------------
flush           proc    near
                mov     bx, bytesavail  ;
                mov     bytesavail,ax
  flushloop:    dec     bx
                jns     SHORT doneflush
                mov     al, BYTE PTR initstate[bx]
                mov     BYTE PTR state[bx], al
                jmp     SHORT flushloop
  doneflush:    ret
flush           endp
  endif
; --------------------------------------------------------------------------
flushdevice     proc    far             ; wipe the buffer
  ife NOHASH
                call    flush
  endif                                 ; does nothing
                jmp     SHORT devok
flushdevice     endp
; --------------------------------------------------------------------------
devstatus       proc    near
; This is needed if we intend to limit the amount of bytes returned
                cmp     freshcount, entropytheshold
                ja      SHORT somentpres ; is enough entropy present?
                mov     ax, BUSY
                jmp     SHORT rfinished
  somentpres:
                jmp     SHORT rdevok
devstatus       endp
; --------------------------------------------------------------------------
rflushdevice    proc    far             ; wipe the buffer
  ife NOHASH
                call    flush
  endif
                jmp     SHORT rdevok
rflushdevice    endp
; --------------------------------------------------------------------------
; This expects to be called with ds == cs and es:[si] -> response header
rdevread        proc    near            ; Read /dev/random
                mov     cx, freshcount         ; check if pool has entropy
                cmp     cx, entropytheshold
                ja      SHORT abovethresh
                mov     es:[di].ReqHdr.Siz, 0  ; if not, return nothing
                jmp     SHORT devstatus
  abovethresh:
                shr     cx, 3                  ; bytes requested > entropy?
                cmp     cx, es:[di].ReqHdr.Siz
                jnb     SHORT enoughentrop
                mov     es:[di].ReqHdr.Siz, cx ; if so, limit output
  enoughentrop:
                mov     cx, es:[di].ReqHdr.Siz  ; Bytes to read
                mov     bx, bytesavail
                les     di, es:[di].ReqHdr.Addr  ; Address to read to
                call    read
                mov     bytesavail, 0   ; throw away remaining bytes
                jmp     rdevok
rdevread        endp
; --------------------------------------------------------------------------
devread         proc    near            ; Read /dev/urandom
; (We could add code to sample idle or mouse movement here...)
                mov     cx, es:[di].ReqHdr.Siz  ; Bytes to read
                mov     bx, bytesavail
                les     di, es:[di].ReqHdr.Addr  ; Address to read to
  DO_READ:
; ----- CAVEAT: rather than calling read and jumping to doneread, we push
;       the address for doneread onto the stack and go to read.
                push    OFFSET doneread
devread         endp
; --------------------------------------------------------------------------
;   cx == bytes to read, bx == available bytes
read            proc    near            ; Read data
; The Read routine was rewritten by Colin Plumb (v0.3)
  readloop:     dec     bx
                jns     SHORT copybyte
                mov     ax, WORD PTR freshcount
                sub     ax, (statesize*8) ; (rawsize if NOHASH set)
                jns     SHORT freshleft
                xor     ax, ax
  freshleft:    xchg    ax, WORD PTR freshcount

  ife NOHASH
                push    cx              ; Oops, we need to hash more data
                call    SHATransform
; ----- Now add the hash output back to the pool.
;       This cheaply stirs up the pool even more.
                mov     cx, statesize/2
                mov     si, OFFSET state
  recycle:
                lodsw
                call    accumulate
                loop    recycle

                pop     cx              ; And restore the pointers
  endif
                mov     bx, statesize-1

  copybyte:     ; ----- Copy bytes to user buffer
  ife NOHASH
                mov     al, BYTE PTR initstate[bx] ; (changed v0.3.5)
                xchg    al, BYTE PTR state[bx]
                ; ----- Don't keep a copy of random data!
  else
                mov     al, BYTE PTR pool[bx]
  endif
                stosb
                loop    readloop
                ret
read            endp

  ife NOHASH
                include sha.inc         ; ----- Secure Hash Transform -----
  endif

  if __samplaudio
@AudioDeltaRec  tDelta  {}
  endif

  if __sample08 ; added v0.3.5
; --------------------------------------------------------------------------
; We don't sample the timer here, rather we use the timer to trigger
; periodic samplings of other things...

; Note that under Windows 3.1 this handler will not be called!!

SamplePeriod    equ     8 ; must be a power of two, unless you change the and
CycleCounter    LABEL   WORD
        DW      SamplePeriod-1
  if __samplmouse
@MouseDeltaRec  tDelta  {}
  endif

                DD      (?)
_timerlatch     proc    far
                pushf
                call    DWORD PTR cs:[_timerlatch-4] ; handle original IRQ0
                dec     WORD PTR cs:[CycleCounter]   ; adjust counter
                js      SHORT ItsTime                ; if < 0, deal with it
                iret
  ItsTime:      push    ds      ; save registers
                push    ax      ; and reset counter
                push    bx
                push    cx
                push    dx
                mov     ax, cs
                mov     ds, ax
                and     WORD PTR CycleCounter, SamplePeriod-1
  if __samplmouse
; ----- Get motion counters from mouse, add changes of position to pool
                mov     ax, 0Bh
    ife __sample33
                int     33h
    else
                pushf
                call    DWORD PTR [_mousesample-4]
    endif
                mov     ax, cx  ; get horizontal mickey count
                add     ax, dx  ; average with vertical mickey count
                shr     ax, 1

                mov     bx, OFFSET @MouseDeltaRec
                call    TrackDeltas
  endif
  if __samplaudio
;;; ----- Note: causes problems for DOS programs that use the soundcard!
;;                SampleAudio   ; Added v0.3.7
  endif
                pop     dx      ; restore registers
                pop     cx
                pop     bx
                pop     ax
                pop     ds
                iret
_timerlatch     endp

  endif

  if __sampldrift
@DriftDeltaRec  tDelta  {}
  endif

  if __sample28
; --------------------------------------------------------------------------
                DD      (?)
_idlewait       proc    near
; We don't have to worry too much about saving all registers in Int 0x28
; (It might be a source of bugs if it doesn't work on some systems...)
                pushf                   ; changed to prior call for v0.3.7
                call    DWORD PTR cs:[_idlewait-4]
                push    ds              ; Save ds, and set ds = cs
                mov     ax, cs
                mov     ds, ax
  if __sampldrift
; Note: this clock-drift sampling is EXPERIMENTAL. The idea is loosley
;       inspired by Matt Blaze and D.P. Mitchell's truerand() code.
; The idea was to use the "drift" between the system timer and the CPU
; when running a tight loop.

                SampleDrift ; Changed to inline macro v0.3.6
  endif
  if __samplaudio
                SampleAudio ; Added v0.3.7
; ----- Should be less of a problem since this is generally called when DOS
;       is idle, but TSRs that use soundcard may have problems.  The macro
;       has a check to prevent audio-sampling while in Windows 3.x
  endif
                pop     ds
                iret
_idlewait       endp
  endif

; ----- The interrupt hooks are here:
  if __sample09
        GenericSampler _keysample
  endif
  if __sample13
        GenericSampler _dsksample
  endif
  if __sample14
        GenericSampler _portsample
  endif
  if __sample33
        GenericSampler _mousesample
  endif

; --------------------------------------------------------------------------
Sample          PROC    NEAR
; Trashes ax and bx, sets ds = cs. Leaves everything else alone.
                mov     ax, cs      ; set ds = cs
                mov     ds, ax
                SampleTimerWord     ; Get 16-bit sample from timer0
Sample          ENDP

TrackDeltas     PROC    NEAR
; ----- Delta-tracking
	mov	cx,ax
        xchg    cx,[bx].tDelta.LastTick
	sub	ax,cx				; Compute delta in ax
	mov	cx,ax
        sub     cx,[bx].tDelta.LastDelta        ; Compute delta2
        mov     [bx].tDelta.LastDelta,ax        ; Store old delta
        jnc     SHORT diff0                 ; Take absolute vlaue of delta2
	neg	cx
diff0:
	cmp	cx,ax			; Find min(delta, delta2)
        jc      SHORT deltamin
	mov	cx,ax	; Carry clear: cx >= ax, so copy ax to cx for minimum
deltamin:
        mov     ax,[bx].tDelta.LastTick ; Reload tick value for accumulate()
	shr	cx,1	; Or other derating factor
        jz      SHORT nofresh ; No significant entropy
	xor	bx,bx	; Pointer no longer needed, this is # of bits
deltaloop:
	inc	bx
	shr	cx,1
        jnz     SHORT deltaloop
;; bx now holds # of bits, > 0
	add	bx, freshcount
	cmp	bx, 512
        jc      SHORT storefresh
	mov	bx, 512	; Carry clear: cx >= dx.
storefresh:
        mov     freshcount, bx
nofresh:
TrackDeltas     ENDP

accumulate      proc    near
  ife NOMIX                  ; ----- pool mixing function by Colin Plumb
                include polynom2.inc
  else                  ; ----- NOMIX accumulation in buffer
; Unmixed accumulation simply adds the new samples to the queue. It is
; used for testing and experimenting with sample methods only!
                mov     bx, index
                add     bx, 2
                and     bx, 62
                mov     index, bx
  endif
                mov     WORD PTR pool[bx], ax        
                ret
accumulate      endp

EndOfDevice     equ     $
; --------------------------------------------------------------------------
; all code after this point is only needed for installation of the driver
; --------------------------------------------------------------------------

; alreadymsg label byte
;  db drvname, ' is already installed!', CR, LF, LF, EndString

; ----- utility routine to convert a two-digit hex/decimal to ascii
;       mov al, byte_to_convert, then do aam 10 or aam 16 for dec or hex
digits          proc    near
                xchg    ax, dx
                xor     bh, bh
                mov     bl, dh
                mov     al, hextbl[bx]
                mov     bl, dl
                mov     ah, hextbl[bx]
                ret
hextbl          label   byte
                db '0123456789ABCDEF'
digits          endp
; ----- hook interrupts and print a small message
;       assumes al=int, bx=routine (save oldvec at bx-4)
install_int     proc    near
                push    ax              ; output Interrupt name
                push    bx
  ifndef MASM
                aam     16 ; (*) MASM 5.0 cannot assemble this
  else
                db      0D4h, 10h
  endif
                call    digits
                mov     WORD PTR HexTxt, ax
                DosPrnt IntMsg
                pop     bx
                pop     ax
; ----- Note: this routine does not check to see if DOS rejects the hook
                pushf
                cli
                push    ax
                push    bx
                mov     ah, 35h
                int     DOS
                pop     ax
                xchg    ax, bx
                mov     WORD PTR [bx-2], es
                mov     WORD PTR [bx-4], ax
                mov     dx, bx
                pop     ax
                mov     ah, 25h
                int     DOS
                popf
                ret
install_int     endp
; --------------------------------------------------------------------------
  initdevice:                          ; assumes es:[di] -> response header
                call    driverinit
                les     bx, DWORD PTR rrh
                lea     dx, EndOfDevice
                mov     WORD PTR es:[bx].ReqHdr.Addr, dx
                mov     WORD PTR es:[bx].ReqHdr.Addr+2, cs
                jmp     finished
; --------------------------------------------------------------------------
OptionFlags     LABEL   WORD
                DW      0
EnableMouse     EQU     0001h
EnablePeriod    EQU     0002h
EnableDrift     EQU     0004h
ShowLicenseFlag EQU     8000h

; ----- interpret command line argumentsd passed to the driver (v0.3.2)
initargs        proc    near
; Note: MS-DOS 5.0 will convert to uppercase from CONFIG.SYS, but
;       DEVLOD will not from the command-line.
                cmp     ah, 'a'
                jb      SHORT IsUpcase
                cmp     ah, 'z'
                ja      SHORT IsUpcase
                sub     ah, 20h
  IsUpcase:
; ----- Rewrite this *very* soon to use tables! -----
  if (initseedcnt ne 0) and (__sample09 ne 0)
                cmp     ah, 'I'     ; /I = Initialize with keystrokes
                jne     SHORT nokey
                mov     seedcount, initseedcnt
                jmp     SHORT argumentloop
  nokey:
  endif
  if __sample28
                cmp     ah, 'W'
                jne     SHORT nodrift
                or      WORD PTR OptionFlags, EnableDrift
                jmp     SHORT argumentloop
  nodrift:
  endif
  if __sample33
                cmp     ah, 'M'
                jne     SHORT NoMouseE
                or      WORD PTR OptionFlags, EnableMouse
                jmp     SHORT argumentloop
  NoMouseE:
  endif
  if __sample08
                cmp     ah, 'P'
                jne     noperiod
                or      WORD PTR OptionFlags, EnablePeriod
                jmp     SHORT argumentloop
  noperiod:
  endif
                cmp     ah, 'L'     ; /L = Show license
                jne     SHORT nolicense
                or      WORD PTR OptionFlags, ShowLicenseFlag
                jmp  SHORT ArgumentLoop
  nolicense:
                mov     BYTE PTR IllegalOption, ah
                DosPrnt Illegal
; Bugs? v0.3.3 no longer works under OS/2 DOS box... the driver always
;       seems to be receiving a /P option.  Define __IgnoreBadOpts
ifndef __IgnoreBadOpts
                mov     ax, -1
                ret
else
                jmp  SHORT ArgumentLoop
endif
initargs        endp
; --------------------------------------------------------------------------
driverinit      proc    near    ; Initialize the driver
; ----- this code was moved to the disposable region, since the driver does
;       not need it after installation (v0.2.2)
                DosPrnt InitMsg
  if __cpu ge 2
                call    TestCPU
                test    ax, ax
                jz      SHORT CorrectCPU
                not     ax
                ret
  CorrectCPU:
  endif
; ----- check for command-line arguments passed to driver (v0.3.2)
                les     di, DWORD PTR es:[di+18]
  ArgumentLoop:
                inc     di
                mov     ax, es:[di]
                cmp     al, CR
                je      SHORT endofargs
                cmp     al, '/'
                jne     SHORT argumentloop
                jmp     SHORT initargs
  endofargs:
                test    WORD PTR OptionFlags, ShowLicenseFlag
                jz      SHORT NoShowLic
                DosPrnt LicenseText
 NoShowLic:
; Possibility of aborting installation if other problems occur...
                DosPrnt StartInstall
; ----- install interrupts -----
  if  __sample08
                test    OptionFlags, EnablePeriod ; v0.4.0, prior to mouse
                jz      SHORT NoEnablePeriod
    if  __samplmouse
; ---- Nasty bug: if no mouse driver is present, the test for a mouse driver
;      may still pass, causing the system to crash and burn unpleasantly!
                xor     ax, ax     ; check if mouse installed (0.3.6)
                int     33h
                test    ax, ax
                jz      SHORT MouseDrvInst
                and     OptionFlags, not (EnableMouse or EnablePeriod)
; ----- Print an error message and abort?
                jmp     SHORT MouseEPE
  MouseDrvInst:
      if __sample33
                test    OptionFlags, EnableMouse
                jnz     SHORT MouseEPE
                mov     ax, 3533h
                int     DOS
                mov     WORD PTR _mousesample-4, bx
                mov     WORD PTR _mousesample-2, es
      endif
  MouseEPE:
    endif
                InstallSampler 8, _timerlatch
  NoEnablePeriod:
  endif
  if __sample09
                InstallSampler 9, _keysample
  endif
  if __sample13
                InstallSampler 13h, _dsksample
  endif
  if __sample14
                InstallSampler 14h, _portsample
  endif
  if __sample33
                test    OptionFlags, EnableMouse
                jz      SHORT NoEnableMouse
                InstallSampler 33h, _mousesample
  NoEnableMouse:
  endif
  if __sample28
                test    OptionFlags, EnableDrift
                jz      SHORT NoEnableIdle
                InstallSampler 28h, _idlewait
  NoEnableIdle:
  endif

                DosPrnt NewLine
; --------------------------------------------------------------------------
  if (initseedcnt ne 0) and (__sample09 ne 0)
; ----- initialize the sampling pool with some keystrokes
                mov     al, BYTE PTR seedcount
                test    al, al
                jz      SHORT nosample
                DosPrnt SeedMessage
  seedlings:
                mov     al, BYTE PTR SeedCount
                xor     ah, ah
                aam     10
                call    digits
                mov     WORD PTR digitcount, ax
                DosPrnt DigitCount
                mov     ah, 0
                int     keyboard
                dec     BYTE PTR seedcount
                jnz     SHORT seedlings
                DosPrnt OkMessage
  nosample:
  endif
                xor     ax, ax       ; return 0 = ok
                ret
driverinit      endp

                include cpuid.inc    ; TestCPU routine

; --------------------------------------------------------------------------
initmsg label byte  ; ----- Initial text messages and other stuff
        db CR, LF
        db drvname, ' v', drvver, ' a random-noise device driver for DOS'
  ifdef ??date
        db ' ', ??date
  endif
        db CR, LF
        db 'by Robert Rothenburg Walking-Owl. Portions by Colin Plumb.'
        db CR, LF, 'Copyright (C) 1995-96, All Rights Reserved.', CR, LF, LF
        db EndString
; ----- This section is for displaying warnings when debug options enabled
NewLine LABEL BYTE
  if (NOHASH+NOMIX)
        db CR, LF, 'WARNING: '
  endif
  if NOHASH
        db 'Hashing is disabled. '
  endif
  if NOMIX
        db 'Mixing is disabled. '
  endif
; ----- End warnings -----
        db CR, LF, EndString
StartInstall LABEL   BYTE
        DB 'Hooking interrupts:', EndString
IntMsg  LABEL   BYTE
        DB ' ??', EndString
HexTxt  equ     $ - 3
  if initseedcnt
seedcount label byte
        db  0   
seedmessage label byte
        db CR, LF
        db 'Please type some random keystrokes to seed the driver: '
        db EndString
digitcount label  byte
        db '00', BackSpace, BackSpace, EndString
okmessage label byte
        db 'Done!', BELL, CR, LF, EndString
  endif
; ----- Command Line Stuff
Illegal LABEL BYTE
        DB 'Illegal option: /?', CR, LF, BELL
IllegalOption   equ $ - 4
        DB 'Allowable options:', CR, LF
  if (initseedcnt ne 0) and (__sample09 ne 0)
        DB ' /I         Initialize entropy pool with keystrokes', CR, LF        
  endif
  if __sample33
        DB ' /M         sample timings between Mouse interrupt calls', CR, LF
  endif
  if __sample08
        DB ' /P         Periodically sample'
    if __samplmouse
        DB ' mouse position'
    endif
;; ----- See Note in TimerLatch routine -----
;;    if (__samplmouse and __samplaudio)
;;       DB ' and'
;;    endif
;;    if __samplaudio
;;        DB ' soundcard input'
;;    endif
        DB CR, LF
  endif
  if __sample28
        DB ' /W         sample'
    if __sampldrift
        DB ' clock drift'
    endif
    if (__sampldrift and __samplaudio)
        DB ' and'
    endif
    if __samplaudio
        DB ' soundcard input'
    endif
        DB ' during DOS idle (Wait)', CR, LF
  endif
        DB ' /L         show software License', CR, LF
        DB EndString
; --------------------------------------------------------------------------
LicenseText: ; accidentally used wrong text, fixed v0.3.4
     DB '    This program is free software; you can redistribute it and/or modify', CR, LF
     DB '    it under the terms of the GNU General Public License as published by', CR, LF
     DB '    the Free Software Foundation.', CR, LF
     DB LF
     DB '    This program is distributed in the hope that it will be useful,', CR, LF
     DB '    but WITHOUT ANY WARRANTY; without even the implied warranty of', CR, LF
     DB '    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the', CR, LF
     DB '    GNU General Public License for more details.', CR, LF
     DB LF
     DB '    You should have received a copy of the GNU General Public License', CR, LF
     DB '    along with this program; if not, write to the Free Software', CR, LF
     DB '    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.', CR, LF
     DB LF, EndString
; --------------------------------------------------------------------------

_TEXT   ends
        end


