program Stuff(input,output); { Stuffs a file into noise pool }

const
  NoiseDevice: String[8] = 'urandom'#0;
  DevUrandom: PChar = Addr(NoiseDevice[1]);
  DevRandom:  PChar = Addr(NoiseDevice[2]);

  IOCTL: Boolean = False;

type
  tNoiseInfo = record
    Siz: Word;        { size of record }
    Sig: LongInt;     { Signature = $5a494f4e 'NOIZ' }
    VMin, VMaj: Byte; { Version Information }
    Flags,
    Reserved,
    FracBits,
    MinBits,
    TopBits,
    EstBits,
    MaxBits: Word;
  end;

  function _Open(var f: File; var FileName): Word;
    assembler;
       asm
            push DS
            lds  DX, FileName
{ ds register is already set to right placer here }
            mov  AX, 3D80h
            Int  21h
            jnc  @ok
       @err:
            xor  AX,AX
            jmp  @quit
       @ok:
            les  BX, f
            mov  ES:[BX], AX     { save file handle }

            mov  BX, AX          { put file into binary mode }
            mov  AX, 4400h       { get device info }
            Int  21h
            jc   @err
            and  DX, 00FFh
            or   DX, 0020h       { "raw" mode }
            mov  AX, 4401h       { set device info }
            Int  21h
            jc   @err
            mov  AX, BX
       @quit:
            pop  DS
       end;

  function Controller(var f: file): Boolean;
    assembler;
  asm
            les  BX, f
            mov  BX, ES:[BX]
            mov  AX, 4400h
            int  21h
            jnc  @noerr
            xor  DX, DX
   @noerr:
            xor  AL, AL
            test DH, $40
            jz   @cntroller
            not  AL
   @cntroller:
  end;

  procedure _Close(var f:File);
    assembler;
  asm
       les  BX, f
       mov  BX, ES:[BX]
       mov  AH, 3Eh
       Int  21h
  end;

function IOCTL_Read(var f, block; size: word): word;
  assembler;
asm
        push ds
        mov  ax, 4402h
        lds  bx, f
        mov  bx, ds:[bx]
        lds  dx, block
        mov  cx, size
        int  21h
        jnc  @ok
        xor  ax, ax
@ok:
        pop  ds
end;

function IOCTL_Write(var f, block; size: word): word;
  assembler;
asm
        push ds
        mov  ax, 4403h
        lds  bx, f
        mov  bx, ds:[bx]
        lds  dx, block
        mov  cx, size
        int  21h
        jnc  @ok
        xor  ax, ax
@ok:
        pop  ds
end;


const
  total: LongInt = 0;

var
  rndstrm, fin: file;
  info: tNoiseInfo;
  block: Array[0..4097] of Word;
  i: Word;
begin
  if _Open(rndstrm,DevRandom^)=0       { test if /dev/random present }
    then DevRandom := nil              { driver not loaded }
    else begin
      IOCTL := Controller(rndstrm);    { is IOCTL present? v0.4.1 if no }
      if IOCTL
      then begin
        IOCTL := (IOCTL_Read(rndstrm, info, SizeOf(tNoiseInfo))<>0);
        if not IOCTL
        then begin
          WriteLn('Error reading control string');
          Halt(1);
        end;
      end;
      _Close(rndstrm);
      if _Open(rndstrm,DevUrandom^)=0   { test if /dev/urandom present }
      then DevUrandom := nil           { NOISE.SYS v0.3.9 or earlier }
      else _Close(rndstrm);
    end;
  if DevRandom=nil
    then WriteLn('Unable to open /dev/random (driver not loaded)')
    else begin
      if DevUrandom=nil
      then WriteLn('Unable to open /dev/urandom (NOISE.SYS v0.3.9 or earlier?)')
      else if not IOCTL
      then WriteLn('No controller functions (NOISE.SYS v0.4.1?)')
      else if info.Sig<>$5a494f4e
      then WriteLn('Bad signature (possibly an incompatible driver?)')
      else begin
        _Open(rndstrm,DevRandom^);
        Assign(fin,ParamStr(1)); FileMode := 0; Reset(fin,1);
        repeat
          BlockRead(fin,block[2],SizeOf(Block)-4,i);
          if i<>0 then begin
            block[0] := i+4;
            block[1] := $0001;
            i:=IOCTL_Write(rndstrm,block,i+4);
            total := total + i;
          end;
        until i=0;
        Close(fin);
        _Close(rndstrm);
      end;
    end;
  WriteLn(total,' bytes sent to driver.');
end.
