; NEWDES block operation, coded in C50 assembler
; W. Ware, 2 Nov 94
;
	.version 50
	.mmregs

	.globl  _nblock
	.globl  _setup_rotor

	.globl  _key_unrav

	.bss    temp,1
	.bss    ar0temp,1
	.bss    buffer,8
	.bss    rotor_buffer,256
	
	.data
rotor:  .int     32, 137, 239, 188, 102, 125, 221,  72
	.int    212,  68,  81,  37,  86, 237, 147, 149
	.int     70, 229,  17, 124, 115, 207,  33,  20
	.int    122, 143,  25, 215,  51, 183, 138, 142
	.int    146, 211, 110, 173,   1, 228, 189,  14
	.int    103,  78, 162,  36, 253, 167, 116, 255
	.int    158,  45, 185,  50,  98, 168, 250, 235
	.int     54, 141, 195, 247, 240,  63, 148,   2
	.int    224, 169, 214, 180,  62,  22, 117, 108
	.int     19, 172, 161, 159, 160,  47,  43, 171
	.int    194, 175, 178,  56, 196, 112,  23, 220
	.int     89,  21, 164, 130, 157,   8,  85, 251
	.int    216,  44,  94, 179, 226,  38,  90, 119
	.int     40, 202,  34, 206,  35,  69, 231, 246
	.int     29, 109,  74,  71, 176,   6,  60, 145
	.int     65,  13,  77, 151,  12, 127,  95, 199
	.int     57, 101,   5, 232, 150, 210, 129,  24
	.int    181,  10, 121, 187,  48, 193, 139, 252
	.int    219,  64,  88, 233,  96, 128,  80,  53
	.int    191, 144, 218,  11, 106, 132, 155, 104
	.int     91, 136,  31,  42, 243,  66, 126, 135
	.int     30,  26,  87, 186, 182, 154, 242, 123
	.int     82, 166, 208,  39, 152, 190, 113, 205
	.int    114, 105, 225,  84,  73, 163,  99, 111
	.int    204,  61, 200, 217, 170,  15, 198,  28
	.int    192, 254, 134, 234, 222,   7, 236, 248
	.int    201,  41, 177, 156,  92, 131,  67, 249
	.int    245, 184, 203,   9, 241,   0,  27,  46
	.int    133, 174,  75,  18,  93, 209, 100, 120
	.int     76, 213,  16,  83,   4, 107, 140,  52
	.int     58,  55,   3, 244,  97, 197, 238, 227
	.int    118,  49,  79, 230, 223, 165, 153,  59

	.text

; ar5 points to rotor_buffer, ar2 points into key_unrav

normal  .macro  a,b,last_ar
	lacl    :a:
	xor     *+,ar5
	samm    indx
	; in order for the code to work correctly, there must be
	; TWO nop instructions here. Why ask why? Try Bud Dry.
	nop
	nop
	mar     *0+
	lacl     *0-,:last_ar:
	xor     :b:
	sacl    :b:
	.endm

wierd   .macro
	lacl    buffer+4
	xor     buffer+5
	samm    indx
	; in order for the code to work correctly, there must be
	; TWO nop instructions here. Why ask why? Try Bud Dry.
	nop
	nop
	mar     *0+
	lacl    *0-,ar2
	xor     buffer+2
	sacl    buffer+2
	.endm

REPS    .equ     7

_nblock ldp     #temp
	sar     ar0,ar0temp
	lrlk    ar5,#rotor_buffer
	mar     *-
	lacl    *+,ar4
	sacl    temp
	lrlk    ar3,#buffer
	lar     ar4,temp
	lacl    #REPS
	samm    BRCR
	rptb    block1-1

	lacl    *+,ar3
	nop
	and     #0FFh
	sacl    *+,ar4
block1

	larp    ar2
	ldp     #buffer
	lrlk    ar2,#_key_unrav
	lacl    #REPS
	samm    BRCR
	rptb    block2-1

	normal  buffer+0,buffer+4,ar2
	normal  buffer+1,buffer+5,ar2
	normal  buffer+2,buffer+6,ar2
	normal  buffer+3,buffer+7,ar2

	normal  buffer+4,buffer+1,ar5
	wierd
	normal  buffer+6,buffer+3,ar2
	normal  buffer+7,buffer+0,ar2
block2

	normal  buffer+0,buffer+4,ar2
	normal  buffer+1,buffer+5,ar2
	normal  buffer+2,buffer+6,ar2
	normal  buffer+3,buffer+7,ar2

	lrlk    ar3,#buffer
	lar     ar4,temp
	larp    ar3
	lacl    #REPS
	samm    BRCR
	rptb    block3-1

	lacl    *+,ar4
	nop
	nop
	sacl    *+,ar3
block3
	sar     ar4,temp
	lar     ar0,ar0temp
	lacl    temp
	larp    ar1
	ret

_setup_rotor
	lrlk    ar2,#rotor_buffer
	lalk    #rotor
	larp    ar2
	rpt	#255
	tblr    *+
	larp    ar1
	ret

	.end
