/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.application.HTMLParsingException;

class HTMLTokenGenerator
extends FilterInputStream {
    public static final byte NULL_TOKEN = 0;
    public static final byte STRING_TOKEN = 1;
    public static final byte MARKER_BEGIN_TOKEN = 2;
    public static final byte MARKER_END_TOKEN = 3;
    public static final byte COMMENT_TOKEN = 4;
    static final byte LAST_TOKEN_TYPE = 4;
    static final int CHARACTER_COUNT_PER_ARRAY = 128;
    static final int CCPA_BIT_COUNT = 7;
    static final int CCPA_MASK = 127;
    static final int PARSING_NONE_STATE = 0;
    static final int PARSING_STRING_STATE = 1;
    static final int PARSING_MARKER_STATE = 2;
    static final int PARSING_COMMENT_STATE = 3;
    static final int PARSING_MARKER_OR_COMMENT_STATE = 4;
    static final int PARSING_END_COMMENT_ONE_STATE = 5;
    static final int PARSING_END_COMMENT_TWO_STATE = 6;
    private byte[][] input = new byte[1][];
    private int nextAvailableByteIndex;
    private int markedByteIndex;
    private int nextFreeByteSlotIndex;
    private int currentLineNumber;
    private int parserState;
    private int currentToken;
    private String currentTokenString;
    private String currentTokenAttributes;

    public HTMLTokenGenerator(InputStream inputStream) {
        super(inputStream);
        this.input[0] = new byte[128];
        this.nextAvailableByteIndex = 0;
        this.nextFreeByteSlotIndex = 0;
        this.currentLineNumber = 0;
        this.parserState = 0;
    }

    private final void markCurrentCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex;
    }

    private final void markPreviousCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex - 1;
    }

    private final void growInputBuffer() {
        byte[][] byArray = new byte[this.input.length + 1][];
        System.arraycopy(this.input, 0, byArray, 0, this.input.length);
        byArray[this.input.length] = new byte[128];
        this.input = byArray;
    }

    private final void readMoreCharacters() throws IOException {
        int n;
        int n2 = this.nextFreeByteSlotIndex >> 7;
        if (n2 >= this.input.length) {
            this.growInputBuffer();
        }
        if ((n = this.read(this.input[n2], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
            this.nextFreeByteSlotIndex += n;
        } else {
            return;
        }
        if (n < 128) {
            n2 = this.nextFreeByteSlotIndex >> 7;
            if (n2 >= this.input.length) {
                this.growInputBuffer();
            }
            if ((n = this.read(this.input[n2], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
                this.nextFreeByteSlotIndex += n;
            }
        }
    }

    private final boolean hasMoreCharacters() throws IOException {
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            return true;
        }
        this.readMoreCharacters();
        return this.nextAvailableByteIndex < this.nextFreeByteSlotIndex;
    }

    private final byte peekNextCharacter() throws IOException {
        byte by = 0;
        if (this.nextAvailableByteIndex >= this.nextFreeByteSlotIndex) {
            this.readMoreCharacters();
        }
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            by = this.input[this.nextAvailableByteIndex >> 7][this.nextAvailableByteIndex & 0x7F];
            ++this.nextAvailableByteIndex;
        }
        return by;
    }

    private final void rewindToMarkedCharacter() {
        this.nextAvailableByteIndex = this.markedByteIndex;
    }

    private final void deletePeekedCharacters() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex >> 7 > 0) {
            byte[] byArray = this.input[0];
            int n = 0;
            int n2 = this.input.length - 1;
            while (n < n2) {
                this.input[n] = this.input[n + 1];
                ++n;
            }
            this.input[this.input.length - 1] = byArray;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final void deletePeekedCharactersMinusOne() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex - 1 >> 7 > 0) {
            byte[] byArray = this.input[0];
            int n = 0;
            int n2 = this.input.length - 1;
            while (n < n2) {
                this.input[n] = this.input[n + 1];
                ++n;
            }
            this.input[this.input.length - 1] = byArray;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final byte[] getAndDeletePeekedCharacters() {
        int n = this.nextAvailableByteIndex - this.markedByteIndex;
        byte[] byArray = new byte[n];
        int n2 = this.markedByteIndex;
        int n3 = this.markedByteIndex + n;
        while (n2 < n3) {
            byArray[n2 - this.markedByteIndex] = this.input[n2 >> 7][n2 & 0x7F];
            ++n2;
        }
        this.deletePeekedCharacters();
        this.markedByteIndex = -1;
        return byArray;
    }

    private final byte[] getAndDeletePeekedCharactersMinusOne() {
        int n = this.nextAvailableByteIndex - this.markedByteIndex - 1;
        byte[] byArray = new byte[n];
        int n2 = this.markedByteIndex;
        int n3 = this.markedByteIndex + n;
        while (n2 < n3) {
            byArray[n2 - this.markedByteIndex] = this.input[n2 >> 7][n2 & 0x7F];
            ++n2;
        }
        this.deletePeekedCharactersMinusOne();
        this.markedByteIndex = -1;
        return byArray;
    }

    private final boolean isSpaceOrCR(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13;
    }

    private String attributes(byte[] byArray) throws HTMLParsingException {
        if (byArray.length == 0 || byArray[0] != 60 || byArray[byArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int n = 1;
        int n2 = byArray.length;
        while (n < n2 && this.isSpaceOrCR(byArray[n])) {
            ++n;
        }
        while (n < n2 && !this.isSpaceOrCR(byArray[n])) {
            ++n;
        }
        while (n < n2 && this.isSpaceOrCR(byArray[n])) {
            ++n;
        }
        if (n2 - 1 - n > 0) {
            return new String(byArray, 0, n, n2 - 1 - n);
        }
        return "";
    }

    private String marker(byte[] byArray) throws HTMLParsingException {
        if (byArray.length == 0 || byArray[0] != 60 || byArray[byArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int n = 1;
        int n2 = 1;
        int n3 = byArray.length;
        while (n < n3 && this.isSpaceOrCR(byArray[n])) {
            ++n;
            ++n2;
        }
        if (byArray[n] == 47) {
            ++n;
            ++n2;
        }
        while (n < n3 - 1 && !this.isSpaceOrCR(byArray[n])) {
            ++n;
        }
        return new String(byArray, 0, n2, n - n2).toUpperCase();
    }

    private boolean isMarkerBegin(byte[] byArray) throws HTMLParsingException {
        if (byArray.length == 0 || byArray[0] != 60 || byArray[byArray.length - 1] != 62) {
            this.syntaxError("Malformed marker");
        }
        int n = 1;
        int n2 = byArray.length;
        while (n < n2 && this.isSpaceOrCR(byArray[n])) {
            ++n;
        }
        return byArray[n] != 47;
    }

    private final void parseOneToken() throws HTMLParsingException, IOException {
        block14: while (this.currentToken == 0) {
            if (!this.hasMoreCharacters()) {
                if (this.parserState == 1 || this.markedByteIndex == -1) break;
                this.rewindToMarkedCharacter();
                break;
            }
            byte by = this.peekNextCharacter();
            if (by == 10) {
                ++this.currentLineNumber;
            }
            switch (this.parserState) {
                case 0: {
                    this.parserState = by == 60 ? 4 : 1;
                    this.markPreviousCharacter();
                    break;
                }
                case 1: {
                    if (by != 60) break;
                    this.currentToken = 1;
                    this.currentTokenAttributes = null;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharactersMinusOne(), 0);
                    this.markPreviousCharacter();
                    this.parserState = 4;
                    break;
                }
                case 2: {
                    if (by != 62) break;
                    byte[] byArray = this.getAndDeletePeekedCharacters();
                    this.currentToken = this.isMarkerBegin(byArray) ? 2 : 3;
                    this.currentTokenAttributes = this.attributes(byArray);
                    this.currentTokenString = this.marker(byArray);
                    this.parserState = 0;
                    break;
                }
                case 4: {
                    if (by == 33) {
                        this.parserState = 3;
                        break;
                    }
                    this.parserState = 2;
                    break;
                }
                case 3: {
                    if (by == 45) {
                        this.parserState = 5;
                        break;
                    }
                    if (by != 62) break;
                    this.currentToken = 4;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                    this.currentTokenAttributes = null;
                    this.parserState = 0;
                    break;
                }
                case 5: {
                    if (by == 45) {
                        this.parserState = 6;
                        break;
                    }
                    if (by == 62) {
                        this.currentToken = 4;
                        this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                        this.currentTokenAttributes = null;
                        this.parserState = 0;
                        break;
                    }
                    this.parserState = 3;
                    break;
                }
                case 6: {
                    if (by == 10 || by == 13) continue block14;
                    if (by == 62) {
                        this.currentToken = 4;
                        this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                        this.currentTokenAttributes = null;
                        this.parserState = 0;
                        break;
                    }
                    this.parserState = 3;
                    break;
                }
            }
        }
        if (this.currentToken == 0 && !this.hasMoreCharacters()) {
            switch (this.parserState) {
                case 1: {
                    this.currentToken = 1;
                    this.currentTokenString = new String(this.getAndDeletePeekedCharacters(), 0);
                    this.currentTokenAttributes = null;
                    this.parserState = 0;
                    return;
                }
                case 2: 
                case 4: {
                    this.parserState = 0;
                    this.syntaxError("Unterminated marker");
                    return;
                }
                default: {
                    this.parserState = 0;
                    this.syntaxError("Unterminated comment. Comment should end with -->");
                    return;
                }
                case 0: 
            }
        }
    }

    public final boolean hasMoreTokens() throws HTMLParsingException, IOException {
        if (this.currentToken != 0) {
            return true;
        }
        this.parseOneToken();
        return this.currentToken != 0;
    }

    public final int nextToken() throws HTMLParsingException, IOException {
        int n = 0;
        if (this.currentToken == 0) {
            this.parseOneToken();
        }
        if (this.currentToken != 0) {
            n = this.currentToken;
            this.currentToken = 0;
        }
        return n;
    }

    final int peekNextToken() throws HTMLParsingException, IOException {
        if (this.currentToken == 0) {
            this.parseOneToken();
        }
        return this.currentToken;
    }

    public final String stringForLastToken() {
        return this.currentTokenString;
    }

    public final String attributesForLastToken() {
        return this.currentTokenAttributes;
    }

    final int lineForLastToken() {
        return this.currentLineNumber + 1;
    }

    final void syntaxError(String string) throws HTMLParsingException {
        throw new HTMLParsingException(string, this.lineForLastToken());
    }
}

