-- ============================================================
--   Database name  :  LIVEPAYMENT                             
--   DBMS name      :  ORACLE 7.x                       
--   Application    :  Starter Application 1.0.0
-- ============================================================

-- ============================================================
--   Table : LP_STATUSTYPE                                        
-- ============================================================
create table LP_STATUSTYPE
(
    STATUSTYPE          VARCHAR2(20)           not null,
    primary key (STATUSTYPE)
);

-- ============================================================
--   Table : LP_CARDTYPE                                        
-- ============================================================
create table LP_CARDTYPE
(
    CARDTYPE          VARCHAR2(20)           not null,
    CARDNAME          VARCHAR2(30)                   ,
    primary key (CARDTYPE)
);

-- ============================================================
--   Table : LP_MATCHQUERY                                        
-- ============================================================
create table LP_MATCHQUERY
(
    ID                NUMBER          not null,
    primary key (ID)
);

-- ============================================================
--   Table : LP_BATCH                                           
-- ============================================================
create table LP_BATCH
(
    ID                  NUMBER               not null,
    BATCHNUMBER         VARCHAR2(10)                   ,
    MERCHANTREFERENCE   VARCHAR2(50)                   ,
    CURRENCY		VARCHAR2(3)                   ,
    TOTALSALESAMOUNT    NUMBER                       ,
    TOTALCREDITAMOUNT   NUMBER                       ,
    SALESCOUNT          NUMBER                       ,
    CREDITCOUNT         NUMBER                       ,
    STATUS              VARCHAR2(20)                   ,
    TIMESETTLED         DATE                         ,
    primary key (ID)
);

-- ============================================================
--   Table : LP_SLIP                                            
-- ============================================================
create table LP_SLIP
(
    ID                  NUMBER               not null,
    SLIPDER             LONG                          ,
    primary key (ID)
);

-- ============================================================
--   Table : LP_PURCHASE                                        
-- ============================================================
create table LP_PURCHASE
(
    ID                  NUMBER               not null,
    MERCHANTREFERENCE   VARCHAR2(50)                   ,
    CARDHOLDERNAME      VARCHAR2(60)                   ,
    CURRENCY		VARCHAR2(3)                    ,
    AMOUNT              NUMBER                       ,
    AUTHCODE            VARCHAR2(20)                   ,
    PAYSVCDATA          VARCHAR2(50)                   ,
    AVSRESP             VARCHAR2(20)                   ,
    EVENTID             VARCHAR2(10)                   ,
    EVENTTIME           DATE                         ,
    SLIPID              NUMBER                       ,
    BATCHID             NUMBER                       ,
    STATUS              VARCHAR2(20)                   ,
    primary key (ID)
);



alter table LP_PURCHASE
    add foreign key (SLIPID)
       references LP_SLIP (ID);

alter table LP_PURCHASE
    add foreign key (BATCHID)
       references LP_BATCH (ID);

@status.sql
@cardtype.sql

commit;
exit;
