/*
This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.
*/

#include <stdio.h>
#include <sys/syscall.h>
#include <errno.h>
#include "sethostid.h"
#include "hid_flags.h"

main(argc, argv)
int argc;
char *argv[];
{
  unsigned hostid;
  int n;

  if (argc<3) {
    fprintf(stderr, "%s <n> <hostid> [hostname]\n", argv[0]);
    exit(1);
  }
  n=atoi(argv[1]);
  sscanf(argv[2], "%x", &hostid);
  fprintf(stderr, "will set hostid for group %d set to %08x\n", 900+n,hostid);
  if (argc == 4) {
    fprintf(stderr, "will set for hostname group %d set to %s\n", 900+n,argv[3]);
    if (syscall(SYS_sethostid, n, HID_HOSTID|HID_HOSTNAME, 
        argv[3], strlen(argv[3]), hostid)==-1) {
      perror(argv[0]);
      exit(1);
    }
  }
  else {
    if (syscall(SYS_sethostid, n, HID_HOSTID, 
        NULL, 0, hostid)==-1) {
      perror(argv[0]);
      exit(1);
    }
  }
  return(0);
}  
