/*
This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.
Mark Henderson <mch@squirrel.com>

25 Feb 1996
*/

#define HOSTID 0xdeadbeef

#include <sys/param.h>
#include <sys/syscall.h>
#include <sys/systm.h>
#include <sys/user.h>
#include <sys/modctl.h>
#include <sys/cred.h>
#include <sys/systeminfo.h>

extern struct mod_ops mod_miscops;

static struct modlmisc modlmisc = {
&mod_miscops,
"sysinit 1.0", 
};

static struct modlinkage modlinkage = {
    MODREV_1, /* magic number */
    &modlmisc, 
    0
};

_init(void)
{
    numtos( (unsigned long)HOSTID, hw_serial);
    return mod_install(&modlinkage);
}
_fini(void)
{
    return mod_remove(&modlinkage);
}

_info(struct modinfo *modinfop)
{
    return (mod_info(&modlinkage, modinfop));
}
