/* socket.c - bind a port and listen for connections */
/* Adapted from code posted by Matthew Ghio */

#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h> /* Required for Linux (but not SunOS) */
#include <unistd.h> /* Required for Linux (but not SunOS) */
#include <sys/wait.h>
               
void reap(){
        while(wait3(0,WNOHANG,0)>0);
}

void wait4connect(int port){
        struct sockaddr_in mya;
        struct servent *sp;
        fd_set muf;
        int myfd,new,x,maxfd=getdtablesize();
        struct sigaction sa;
        sigemptyset (&sa.sa_mask);
        sa.sa_flags = 0;
        sa.sa_handler = reap;
        sigaction(SIGCHLD, &sa, 0);
        if((myfd=socket(AF_INET,SOCK_STREAM,
            0))<0)exit(1);
        mya.sin_family=AF_INET;
        bzero(&mya.sin_addr,
            sizeof(mya.sin_addr));
        if(port<=0)exit(1);
        mya.sin_port=htons(port);
        if(bind(myfd,
            (struct sockaddr *)&mya,sizeof(mya)))exit(1);
        if(listen(myfd,
            1)<0)exit(1);
loop: 
        FD_ZERO(&muf);
        FD_SET(myfd,&muf);
        if(select(myfd+1,&muf,0,0,0)!=1||!FD_ISSET(myfd,&muf))
            goto loop;
        if((new=accept(myfd,0,0))<0)goto loop;
        if(fork()==0){
                for(x=2;x<maxfd;x++)if(x!=new)close(x);
                for(x=0;x<NSIG;x++)signal(x,SIG_DFL);
                dup2(new,0);
                close(new);
                dup2(0,1);
                dup2(0,2);
                return;
        }
        close(new);
        goto loop;
}
