/*
 *	$Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/erlogin/RCS/rlogin.c,v $
 *	$Author: jtkohl $
 *	$Header: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/erlogin/RCS/rlogin.c,v 4.3 88/03/17 10:41:35 jtkohl Exp $
 */

#ifndef lint
static char *rcsid_rlogin_c = "$Header: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/erlogin/RCS/rlogin.c,v 4.3 88/03/17 10:41:35 jtkohl Exp $";
#endif lint

/*
 * Copyright (c) 1983 Regents of the University of California.
 * Changes Copyright (c) 1987 Massachusetts Institute of Technology.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 Changes Copyright (c) 1987 Massachusetts Institute of Technology.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)rlogin.c	5.10 (Berkeley) 3/30/86";
#endif not lint

/*
 * rlogin - remote login
 */
#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include <stdio.h>
#include <sgtty.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <setjmp.h>
#include <netdb.h>
#ifdef KERBEROS
#include <krb.h>
#endif /* KERBEROS */
#include <strings.h>
#include "fifo.h"

# ifndef TIOCPKT_WINDOW
# define TIOCPKT_WINDOW 0x80
# endif TIOCPKT_WINDOW

/*
 *    TIOCPKT_WINDOW is sort of a misnomer, which assumes that
 * TIOCPKT_ prefixes all out-of-band msg macro-names.
 * actually, this prefix is just for the pseudo-tty control bits;
 * see pty(4) in the 4.3bsd docs.
 *    When rlogind passes a pty control byte to us,
 * we have to treat the byte as a bit-vector.
 * In other contexts, we're free to treat the oob-char as a number,
 * so the RLOGIN_ macros do not just name single bits.
 * Nevertheless, for compatibility, these avoid bits 0-5, which TIOCPKT_ uses.
 * See Readeroob(), below.
 * RLOGIN_ENVIRONMENT_VAR includes the TIOCPKT_WINDOW bit, but we never
 * receive R..L..VAR, so it doesn't look like the latter to our oob handlers.
 */

/* TBD: these should use the lower bits, not the upper ones */
#define RLOGIN_ENVIRONMENT_OK	0x40
#define RLOGIN_ENVIRONMENT_VAR	0xc0

#ifndef sigmask
#define sigmask(m)	(1 << ((m)-1))
#endif

/*
 * macros for mode subr's argument
 */
#define SAVE_TTY 0
#define USER_TTY 1
#define TRANSP_TTY 2
#define FLOW_CTL_ON 3
#define FLOW_CTL_OFF 4

#define CRLF "\r\n"

/*    Rlogin is the client program, rlogind is the server program.
 *    Rlogin opens a socket to the remote network daemon (inetd or knetd),
 * then becomes a transparent, 2-way, tty-to-socket translator.
 * Rlogin's translator consists of two processes, called the Reader and
 * the Writer.
 *    Rlogind also becomes such a transparent translator, after spawning a
 * Login child process. Rlogind's translator is a single process,
 * called the Protocol process.
 *    Thus, we're talking four, count 'em, four processes here:
 *
 *          / READER \
 * loc_tty <          >loc_sock<===>rem_sock<-->PROTOCOL<-->pty<-->LOGIN/SH
 *          \ WRITER /
 *
 * A priori, one would think that rlogin's translator could be constructed
 * like rlogind's, so as to require only a single process. Unfortunately,
 * such a rewrite would be a substantial piece of work, because of the
 * elaborations detailed below.
 *    There are six data-transfer protocols between the client & server:
 *
 *	1) Most of the socket traffic carries ASCII between the local tty
 *	   and the login/shell process.
 *	2) The server sporadically passes PTY CONTROL-CODES down to the client.
 *	3) At startup, the client passes USER-NAMES & TERM-TYPE info up to
 *	   the server.
 *	4) At startup, and occasionally thereafter, the client passes WINDOW-
 *	   SIZES up to the server, if the rlogin window is locally-managed.
 *	   The server initiates this protocol.
 *	5) At startup, the client may pass a KERBEROS ticket up to the server.
 *	6) At startup, the client passes c-shell ENVIRONMENT variable/value 
 *	   pairs up to the server. The server initiates this protocol.
 *
 * Historically, protocols 1-3 are 4.2bsd functionality (perhaps version 7
 * did them too). Protocol 4 was added for 4.3bsd, but it has been redesigned
 * for 4.3.0.3. Protocols 5 & 6 are new to version 4.3.0.3. In addition,
 * 4.3bsd rcmd/rlogind had a socket-checking swap of null characters at startup;
 * this has been removed, as 4.3.0.3 no longer calls rcmd unless knetd is
 * unavailable, and kerberos' ticket-transfer checks the socket more
 * stringently.
 *    Protocols 4-6 are independent, and can be installed (via #ifdef controls)
 * in any combinmation. Protocols 1-3 are common to all versions, though
 * Kerberos authentication (#5) modifies protocol 3.
 *    Much of the complexity of rlogin comes from its backwards-compatibility;
 * for example, 4.3 rlogin can talk to 4.2 rlogind, because 4.2 rlogind won't
 * initiate the window-passing protocol. In general, the 4.3.0.3 rlogin client
 * can talk to any server: 4.2, 4.3, 4.3.0.3; indeed, client/server pairs
 * which support different subsets of 4.3.0.3 functionality should not break.
 */

/*
 * external decls
 */
extern	int errno;
int	exit();
char	*index(), *rindex(), *malloc(), *getenv();
int	lostpeer();
struct	passwd *getpwuid();

/* external routines for window-size passing */
int	setup_win();
int	writeroob();
int	sendwindow();

/* external routines for environment passing */
int	setup_env();
int	sendenv();

/*
 * most global var's decls, alphabetized. please keep it that way.
 */
int	catchild();
int	readeroob();

int	child;
char	cmdchar = '~';
int	confirm = 0;		/* ask if ~. is given before dying. */
char	*cp = (char *) NULL;
int	done();
int	eight = 1;		/* Default to 8 bit transmission */
int	flow;			/* host's last-requested flow-control state */
char	*host;
int	litout;
char	*name;
int	noflow_opt = 1;		/* turn off flow control option */
int	no_local_escape = 0;
int	null_local_username = 0;
int	options = 0;
int	parent;
int	rem;			/* socket descriptor */
char	*speeds[] = { "0", "50", "75", "110", "134", "150", "200", "300", "600",
                     "1200", "1800", "2400", "4800", "9600", "19200", "38400" };
char	term[256] = "network";

#ifdef DBG
int	rldebug = 0;
FILE	*dbg;			/* file-desc'r for DBG_FPRINTF macro */
#endif DBG

main(argc, argv)
	int argc;
	char **argv;
{

	host = rindex(argv[0], '/');
	if (host)
		host++;
	else
		host = argv[0];
	argv++, --argc;
	if (!strcmp(host, "erlogin"))
		host = *argv++, --argc;
another:
	if (argc > 0 && !strcmp(*argv, "-d")) {
		argv++, argc--;
		DBG_SET;
		options |= SO_DEBUG;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-c")) {
		confirm = 1;
		argv++; argc--;
		goto another;
		}
	if (argc > 0 && !strcmp(*argv, "-a")) {	   /* ask -- make remote */
		argv++; argc--;			/* machine ask for password */
		null_local_username = 1;	/* by giving null local user */
		goto another;			/* id */
	}
	if (argc > 0 && !strcmp(*argv, "-t")) {
		argv++; argc--;
		if (argc == 0) usage();
		cp = *argv++; argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-l")) {
		argv++, argc--;
		if (argc == 0) usage();
		name = *argv++; argc--;
		goto another;
	}
	if (argc > 0 && !strncmp(*argv, "-e", 2)) {
		cmdchar = argv[0][2];
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-n")) {
		no_local_escape = 1;
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-7")) {  /* Pass only 7 bits */
		eight = 0;
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-8")) {
		eight = 1;
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-flow")) {
		noflow_opt = 0;  /* turn on local flow control; trap ^S */
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-noflow")) {
		noflow_opt = 1;	/* no local flow control; let emacs get ^S */
		argv++, argc--;
		goto another;
	}
	if (argc > 0 && !strcmp(*argv, "-L")) {
		litout = 1;
		argv++, argc--;
		goto another;
	}
	if (host == 0) usage();
	if (argc > 0)  usage();
	doit();
} /* end main */

doit()
/*    Set up a socket connection to the remote host, and run two processes:
 * the parent process transmits local keystrokes to the socket, while
 * the child process copies the socket's reception to the screen.
 * the writer must be parent, so that ~^Y can work.
 *    Further, the child may receive out-of-band messages from the remote host;
 * its out-of-band handler, Readeroob, interprets and acts on these messages.
 *    Briefly, the out-of-band mechanism (using send and recv) allows the 
 * multiplexing of an extra data stream into the normal stream i/o of the
 * socket. For more info about out-of-band, see chapter 5 in the Advanced
 * Interprocess Communications Tutorial, in the UNIX Programmer's Suppl. Docs,
 * vol I. */
{
	int oldmask;
	int on = 1;
	char	*locuser, *remuser;
	struct passwd *pwd;
	struct sgttyb sb;
	struct servent *sp;
	int uid;
	long authopts;

	DBG_FOPEN(dbg, "/tmp/cdbg");
	DBG_SET;
	DBG_FPRINTF((dbg, "doit: cdbg opened.\n"));

	pwd = getpwuid(getuid());
	if (pwd == 0) {
		fprintf(stderr, "Who are you?\n");
		exit(1);
	}
	/* setup preamble data: local username, desired remote username,
	 * termtype (usually xterm) and terminal speed.
	 */
	locuser = null_local_username ? (char *)NULL : pwd->pw_name;
	remuser = name ? name : pwd->pw_name;
	DBG_FPRINTF((dbg, "locuser = %s, remuser = %s\n", locuser, remuser));

	if (cp == (char *) NULL) cp = getenv("TERM"); /* usually "xterm" */
	if (cp) strcpy(term, cp);

	if (ioctl(0, TIOCGETP, &sb) == 0) {
		strcat(term, "/");
		strcat(term, speeds[sb.sg_ospeed]);
	}

	signal(SIGPIPE, lostpeer);

	/* make all local signals wait until after fork:
	 */
	oldmask = sigblock(sigmask(SIGURG)  |
			   sigmask(SIGUSR1) |
			   sigmask(SIGUSR2) );

#ifdef KERBEROS
	sp = getservbyname("erlogin", "tcp");
	/* sp = NULL; /* force inetd service */
	if (sp != NULL) {
		KTEXT ticket = (KTEXT)NULL;
		struct hostent *hp;
		struct sockaddr_in sin;
		int kerr;

		hp = gethostbyname(host);
		if (hp == 0) {
			fprintf(stderr, "%s: unknown host\n", host);
			exit(1); }
		sin.sin_family = hp->h_addrtype;
		bcopy(hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
		sin.sin_port = sp->s_port;
		rem = socket(hp->h_addrtype, SOCK_STREAM, 0);
		if (rem < 0) { perror("socket"); exit(1); }

		/* we want to get SIGURG's from the socket.
		 * we have to accept such SIGURG's ASAP, because
		 * rlogind sends protocol requests out-of-band at startup.
		 * in the inetd case, rcmd does this fcntl for us.
		 */
		fcntl(rem, F_SETOWN, getpid());

		if (connect(rem, (char*)&sin, sizeof(sin)) < 0) {
			perror("connect"); close(rem); exit(1); }

		ticket = (KTEXT)malloc( sizeof(KTEXT_ST) );
		DBG_FPRINTF((dbg, "probe 1\n"));
		authopts = 0L;
		kerr = krb_sendauth(authopts, rem, ticket, "rcmd", host,
				    NULL, (unsigned long) getpid(),
				    (MSG_DAT *) 0, (CREDENTIALS *) 0,
				    (struct sockaddr_in *) 0,
				    &sin,
				    "ERLGV0.1");
		DBG_FPRINTF((dbg, "probe 2\n"));
		if (kerr != KSUCCESS) {
			DBG_FPRINTF((dbg, "Kerberos failure.\n"));
			fprintf(stderr, "kerberos failed: %d %s\n",
				kerr, krb_err_txt[kerr]);
			printf("you'll have to setenv DISPLAY yourself.\n");
			/*
			 * try non-kerberos login:
			 */
			sp = NULL;
		}
		DBG_FPRINTF((dbg, "Kerberos success.\n"));

		/* send the usual preamble stuff to rlogind,
		 * which is traditionally sent by rcmd:
		 */
	     /* write (rem, locuser, strlen(locuser)+1); */
		write (rem, remuser, strlen(remuser)+1);
		write (rem, term,    strlen(term)+1);
	}
	if (sp == NULL) {
		/* Give up on Kerberos, and go for a standard inetd connection.
		 * set up the socket on a reserved port; the cmd argument
		 * 'term' has a value like "xterm/38400", and isn't to be
		 * executed, but will be unpacked remotely, by login. */

#else /* ! KERBEROS */
	{
#endif /* KERBEROS */
		sp = getservbyname("login", "tcp");
		if (sp == NULL) {
			fprintf(stderr, "rlogin: login/tcp: unknown service\n");
			exit(2);
		}
		rem = rcmd(&host, sp->s_port, locuser, remuser, term, 0);
		if (rem < 0) exit(1);

		if (options & SO_DEBUG &&
		    setsockopt(rem, SOL_SOCKET, SO_DEBUG, &on, sizeof (on)) < 0)
			perror("rlogin: setsockopt (SO_DEBUG)");
	}
	setup_win(rem);	/* tell oob-handlers how to use the socket */

#ifdef ENV
	setup_env(rem);
#endif ENV

	uid = getuid();
	if (setuid(uid) < 0) {
		perror("rlogin: setuid");
		exit(1);
	}
	/* Athena default is to DISallow flow control at the local tty.	*/
	/* Since emacs can alter the flow control characteristics of a	*/
	/* session, we need a variable to keep track of the original	*/
	/* characteristics.   */
	flow = !noflow_opt;

	mode(SAVE_TTY);   /* save the current tty setup */
	signal(SIGINT, SIG_IGN);
	signal(SIGHUP, done);
	signal(SIGQUIT, done);
	signal(SIGCHLD, catchild);	/* ensure parent buries dead child */
	parent = getpid();
	child = fork();
	if (child == -1) {
		perror("rlogin: fork");
		done(1);
	}
	if (child == 0) { /* child */
		fcntl(rem, F_SETOWN, getpid()); /* only reader gets SIGURG's */
		mode(TRANSP_TTY);  /* transparent mode while we listen to net */
		signal(SIGTTOU, SIG_IGN);
		signal(SIGURG, readeroob);

		DBG_FPRINTF((dbg, "before reader\n"));
		if (reader(oldmask) == 0) {
			prf("reader: Connection closed.");
			done(0);
		}
		sleep(1);
		prf("\007Connection closed.");
		done(3);
	}
	/* parent */
#ifdef ENV
	signal(SIGUSR1, sendenv);
#endif ENV
	signal(SIGUSR2, writeroob);
	sigsetmask(oldmask);	/* enable SIGUSR's & discard pending SIGURG's */
	writer();
	prf("Closed connection.");
	done(0);
} /* end doit */

done(status)
	/*
	 * the parent (Writer) must always call this routine in order to exit.
	 * such a route is best for the child (Reader) too.
	 */
	int status;
{

	mode(USER_TTY);
	if (child > 0 && kill(child, SIGKILL) >= 0)
		wait((int *)0);
	DBG_FPRINTF((dbg, "%d done: status = %d\n", getpid(), status));
	DBG_FCLOSE(dbg);
	exit(status);
}

int	defflags;	/* holds only user's ECHO and CRMOD bits */
int	tabflag;	/* holds user's TBDELAY bits */
int	deflflags, tranlflags;
char	deferase, defkill;
struct	tchars deftc;
struct	ltchars defltc;
struct	tchars notc =	{ -1, -1, -1, -1, -1, -1 };
struct	ltchars noltc =	{ -1, -1, -1, -1, -1, -1 };

mode(f) /*    toggle the terminal setup, between the USER's original one, and
	 * a TRANSparent mode, which turns off most special chars & flags.
	 * SAVE mode initializes the whole deal.
	 *    The paradigm is that when the tty is talking to the remote host,
	 * we want to be in transparent mode; when the rlogin session is
	 * suspended or stopped, the local host should be connected to the tty,
	 * and we want to be in user mode.
	 *    Though stdin is specified, it's actually stdout that we're
	 * interested in, and it's almost always the Reader process (which
	 * writes to the screen) that toggles this terminal mode setting. */
{
	struct tchars *tc;
	struct ltchars *ltc;
	struct sgttyb sb;
	int	lflags;

	ioctl(0, TIOCGETP, (char *)&sb);
	switch (f) {
	case SAVE_TTY: /* "save user setup" mode; also init's transp. setup */
		defflags = sb.sg_flags;
		tabflag = defflags & TBDELAY;
		defflags &= ECHO | CRMOD;
		deferase = sb.sg_erase;
		defkill = sb.sg_kill;

		ioctl(0, TIOCGETC, (char *)&deftc);
		notc.t_startc = deftc.t_startc;
		notc.t_stopc = deftc.t_stopc;

		ioctl(0, TIOCGLTC, (char *)&defltc);

		ioctl(0, TIOCLGET, (char *)&lflags);
		tranlflags = deflflags = lflags;
		if (litout) tranlflags |= LLITOUT;
		if (eight)  tranlflags |= LPASS8;
		return;
		
	case USER_TTY: /* "user" mode, restores user's original tty setup. */
		sb.sg_flags &= ~(CBREAK|RAW|TBDELAY); /* "cooked" data */
		sb.sg_flags |= defflags|tabflag;
		sb.sg_kill = defkill;
		sb.sg_erase = deferase;

		tc = &deftc;
		ltc = &defltc;
		lflags = deflflags;
		break;

	case TRANSP_TTY: /* "transparent" mode, for letting the net control
			  * the screen. turn off local echo and cr -> crlf,
			  * so that the remote host controls all printing.
			  * cbreak enables only ^S^Q; ^C,^Y,^Z, and ^\ are
			  * turned off because notc & noltc are ful of -1's.
			  * the remote host can set flow.
			  */
		sb.sg_flags &= ~(CBREAK | ECHO | CRMOD);
		sb.sg_flags |= RAW;	/* no flow-control is the default*/
		sb.sg_kill = sb.sg_erase = -1;
		
		if ((sb.sg_flags & TBDELAY) == XTABS)	/* keep tab delays, */
		     sb.sg_flags &= ~XTABS;		/* but turn off XTABS */

		tc = &notc;
		ltc = &noltc;
		lflags = tranlflags;

		/* We distinguish three records of the flow-control state:
		 * noflow_opt == the user's command-line request;
		 * flow == the last request of the host (default: noflow_opt);
		 * sb.sg_flags == the actual current state, which the
		 *    user may have modified, if we've been stopped.
		 * In any case, restore the host's last-requested state:
		 */
		if (!flow) break;	/* else fall through to FLOW_CTL_ON */

	case FLOW_CTL_ON:
		flow = 1;		/* record the host-requested state */
		sb.sg_flags &= ~RAW;
		sb.sg_flags |= CBREAK;
		notc.t_stopc = -1;
		notc.t_startc = -1;
                tc = &notc;
		break;

	case FLOW_CTL_OFF:
		flow = 0;		/* record the host-requested state */
		sb.sg_flags &= ~CBREAK; /* return to the default state */
		sb.sg_flags |= RAW;
		notc.t_stopc  = deftc.t_stopc;
		notc.t_startc = deftc.t_startc;
                tc = &notc;
		break;

	default:
		return;
	}
	ioctl(0, TIOCSETN, (char *)&sb);
	ioctl(0, TIOCSETC, (char *)tc);
	ioctl(0, TIOCSLTC, (char *)ltc);
	ioctl(0, TIOCLSET, (char *)&lflags);
} /* end mode subr */

/*
 * Writer: write to remote: 0 -> line.
 * ~.	terminate
 * ~^Z	suspend rlogin process.
 * ~^Y  suspend Writer process, but leave Reader alone.
 */
writer()
{
	char c;
	register n;
	register bol = 1;               /* beginning of line */
	register local = 0;

	for (;;) {
		n = read(0, &c, 1);
		if (n <= 0) {
			if (n < 0 && errno == EINTR)
				continue;
			break;
		}
		/*
		 * If we're at the beginning of the line
		 * and recognize a command character, then
		 * we echo locally.  Otherwise, characters
		 * are echo'd remotely.  If the command
		 * character is doubled, this acts as a 
		 * force and local echo is suppressed.
		 */
		if (bol) {
			bol = 0;
			if (c == cmdchar) {
				bol = 0;
				local = 1;
				continue;
			}
		} else if (local) { /* interpret special chars */
			local = 0;
			if (c == '.' || c == deftc.t_eofc) {
			    if (confirm_death()) {
				echo(c);
				break;
			    }
			}
			if ((c == defltc.t_suspc || c == defltc.t_dsuspc)
				&& !no_local_escape) {
				bol = 1;
				echo(c);
				stop(c);
				continue;
			}
			if (c != cmdchar)
				write(rem, &cmdchar, 1);
		}
		if (write(rem, &c, 1) == 0) {
			prf("line gone");
			break;
		}
		bol = c == defkill || c == deftc.t_eofc ||
		    c == deftc.t_intrc || c == defltc.t_suspc ||
		    c == '\r' || c == '\n';
	}
} /* end Writer subr */

echo(c)
register char c;
{
	char buf[8];
	register char *p = buf;

	c &= 0177;
	*p++ = cmdchar;
	if (c < ' ') {
		*p++ = '^';
		*p++ = c + '@';
	} else if (c == 0177) {
		*p++ = '^';
		*p++ = '?';
	} else
		*p++ = c;
	*p++ = '\r';
	*p++ = '\n';
	write(1, buf, p - buf);
}

stop(cmdc)
	char cmdc;
{
	mode(USER_TTY);	/* return tty to user's setup while we're stopped */

	/*
	 * if cmdc = ^Z, suspend process group (Reader and Writer);
	 *	     ^Y, suspend self (Writer process only).
	 */
	kill(cmdc == defltc.t_suspc ? 0 : getpid(), SIGTSTP);

	mode(TRANSP_TTY);	/* transparent mode while we listen to net */

	sendwindow();	/* tell rem host if the size changed while we slept */
}

int
confirm_death ()
{
	char hostname[33];
	char answer;
	if (!confirm) return (1);	/* no confirm, just die */

	if (gethostname (hostname, sizeof(hostname)-1) != 0)
		strcpy (hostname, "???");
	else
		hostname[sizeof(hostname)-1] = '\0';

	fprintf (stderr, "\r\nKill session on %s from %s (y/n)?  ",
			 host, hostname);
	fflush (stderr);
	if (read(0, &answer, 1) != 1) answer = EOF;	/* read from stdin */
	fprintf (stderr, "%c\r\n", answer);
	fflush (stderr);
	return (answer == 'y' || answer == 'Y' || answer == EOF ||
		answer == 4);	/* control-D */
}

/*
 * Reader: read from remote: line -> 1
 */
#define	READING	1
#define	WRITING	2

char	rcvbuf[8 * 1024];
int	rcvcnt;
int	rcvstate;
jmp_buf	rcvtop;

reader(oldmask) int oldmask;
{
	int n, remaining;
	char *bufp = rcvbuf;

	(void) setjmp(rcvtop);

	/* have to set rcvtop before restoring SIGURG's,
	 * because Readeroob needs for rcvtop to be right.
	 */
	sigsetmask(oldmask);	/* enable SIGURG */

	for (;;) {
		while ((remaining = rcvcnt - (bufp - rcvbuf)) > 0) {
			rcvstate = WRITING;
			n = write(1, bufp, remaining);
			if (n < 0) {
				if (errno != EINTR)
					return (-1);
				continue;
			}
			bufp += n;
		}
		bufp = rcvbuf;
		rcvcnt = 0;
		rcvstate = READING;
#ifdef DBG
		oldmask = sigblock(SIGURG);
		if ((ioctl(rem, SIOCATMARK, &n), *(char*)&n) &&
		     recv(rem, &n, 1, MSG_OOB | MSG_PEEK)) {
			DBG_FPRINTF((dbg, "oob_char: %x\n",*(char*)&n));
		}
		sigsetmask(oldmask);
#endif DBG
		rcvcnt = read(rem, rcvbuf, sizeof (rcvbuf));
		if (rcvcnt == 0)
			return (0);
		if (rcvcnt < 0) {
			if (errno == EINTR)
				continue;
			perror("read");
			return (-1);
		}
	}
} /* end Reader subr */

readeroob()
{
	int out = FWRITE, atmark, n;
	int rcvd = 0;
	char waste[BUFSIZ];
	unsigned char mark;

	DBG_FPRINTF((dbg, ">>readeroob: mark = \n"));

	while (recv(rem, &mark, 1, MSG_OOB) < 0)
		switch (errno) {
		
		case EWOULDBLOCK:
			/*
			 * Urgent data not here yet.
			 * It may not be possible to send it yet
			 * if we are blocked for output
			 * and our input buffer is full.
			 */
			if (rcvcnt < sizeof(rcvbuf)) {
				n = read(rem, rcvbuf + rcvcnt,
					sizeof(rcvbuf) - rcvcnt);
				if (n <= 0)
					return;
				rcvd += n;
			} else {
				n = read(rem, waste, sizeof(waste));
				if (n <= 0)
					return;
				waste[n-1] = '\0';
				DBG_FPRINTF((dbg, "flushing 1: %s", waste));
			}
			continue;
				
		default:
			return;
	} /* end while loop */

	DBG_FPRINTF((dbg, "	%.2x\n", mark));

#ifdef ENV
	if (mark == RLOGIN_ENVIRONMENT_OK) {
		/*
		 * rlogind is responding "yes" to our query,
		 * "can you accept environment variables & values?".
		 * so, it's waiting for them, and we can send them now.
		 */
		kill(parent, SIGUSR1);

		DBG_FPRINTF((dbg, "<<readeroob (env case).\n"));
		return;
	}
#endif ENV

	if (mark & TIOCPKT_WINDOW) {
		/*
		 * Ordinarily, this oob msg arrives once, on rlogind startup.
		 * Invoke Writeroob to send winsize out on the socket, so as
		 * to let the server (rlogind) know about window size changes.
		 */
		kill(parent, SIGUSR2);
	}
	if (noflow_opt && (mark & TIOCPKT_NOSTOP)) { /* ignore ^S ^Q */
		mode(FLOW_CTL_OFF);
	}
	if (noflow_opt && (mark & TIOCPKT_DOSTOP)) { /* obey ^S ^Q */
 		mode(FLOW_CTL_ON);
	}
	if (mark & TIOCPKT_FLUSHWRITE) {
		ioctl(1, TIOCFLUSH, (char *)&out);
		for (;;) {
			if (ioctl(rem, SIOCATMARK, &atmark) < 0) {
				perror("ioctl");
				break;
			}
			if (atmark)
				break;
			n = read(rem, waste, sizeof (waste));
			if (n <= 0)
				break;
			waste[n-1] = '\0';
			DBG_FPRINTF((dbg, "flushing 2: %s", waste));
		}
		/*
		 * Don't want any pending data to be output,
		 * so clear the recv buffer.
		 * If we were hanging on a write when interrupted,
		 * don't want it to restart.  If we were reading,
		 * restart anyway.
		 */
		rcvcnt = 0;
		longjmp(rcvtop, 1);
	}
	DBG_FPRINTF((dbg, "<<readeroob.\n"));

	/*
	 * If we filled the receive buffer while a read was pending,
	 * longjmp to the top to restart appropriately.  Don't abort
	 * a pending write, however, or we won't know how much was written.
	 */
	if (rcvd && rcvstate == READING)
		longjmp(rcvtop, 1);

} /* end readeroob */

/*
 * miscellaneous signal-handling routines.
 */

lostpeer()
{
	signal(SIGPIPE, SIG_IGN);
	prf("\007lostpeer: Connection closed.");
	done(1);
}

catchild() {
	/* the child (reader) will die when it gets an EOF from
	 * the remote host, e.g., when the remote session dies at logout.
	 */
	union wait status;
	int pid;

	DBG_FPRINTF((dbg, ">>catchild. parent = %d.\n", getpid()));

	while (pid = wait3(&status, WNOHANG|WUNTRACED, 0)) {
		/*
		 * wait cleans the child out of the kernel's process table.
		 * quit if the child (Reader) dies, unless the user stopped it.
		 */
		if (pid < 0 || pid == child && !WIFSTOPPED(status))
			done(status.w_termsig | status.w_retcode);
		DBG_FPRINTF((dbg, "catchild: pid = %d. not dead yet\n", pid));
	}
	DBG_FPRINTF((dbg, "<<catchild: parent not dead\n"));
}

/*VARARGS*/
prf(f, a1, a2, a3, a4, a5)
	char *f;
{
	fprintf(stderr, f, a1, a2, a3, a4, a5);
	fprintf(stderr, CRLF);
}

usage()
{
	fprintf (stderr,
	"usage: erlogin host [-option] [-option...] [-t ttytype] [-l username]\n");
    	fprintf (stderr,
        "     where option is e, 7, 8, flow, noflow, n, a, or c\n");
  	exit(1);
}
