
/*
 *	$Source: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/erlogin/RCS/rlogind.c,v $
 *	$Author: probe $
 *	$Header: /afs/rel-eng.athena.mit.edu/project/release/current/source/athena/athena.lib/kerberos/appl/erlogin/RCS/rlogind.c,v 4.4 91/02/28 22:59:31 probe Exp $
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * Changes Copyright (c) 1987 Massachusetts Institute of Technology.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 Changes Copyright (c) 1987 Massachusetts Institute of Technology.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)rlogind.c	5.11 (Berkeley) 5/23/86";
#endif not lint

/*
 * remote login server:
 *	remuser\0
 *	locuser\0
 *	terminal info\0
 *	data
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>

#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <sgtty.h>
#include <netdb.h>
#include <syslog.h>
#include <strings.h>
#include "fifo.h"

extern		errno;
extern int	netf;
extern struct	fifo	netfbuf;

extern char**	req_and_await_env();
extern int	request_winsiz();
extern char*	inet_ntoa();
extern char*	malloc();

struct	passwd *getpwnam();

#ifdef DBG
FILE	*dbg;
int	rldebug = 0;
#endif DBG

main(argc, argv)
	int argc;
	char **argv;
{
	int on = 1, options = 0, fromlen;
	struct sockaddr_in from;

#ifdef DBG
	DBG_SET;
	DBG_FOPEN(dbg, "/tmp/sdbg");
	if (dbg == NULL) {
#ifndef LOG_DAEMON
		openlog("rlogind", LOG_PID | LOG_TIME);
#else
		openlog("rlogind", LOG_PID, LOG_DAEMON);
#endif /* 4.2 style syslog */
		syslog(LOG_DEBUG, "fopen failed");
		closelog();
	}
	DBG_FPRINTF((dbg, "rlogind: entry to main\n"));
#endif DBG

#ifndef LOG_AUTH
	openlog("rlogind", LOG_PID | LOG_TIME);
#else
	openlog("rlogind", LOG_PID | LOG_AUTH, LOG_AUTH);
#endif /* 4.2 style syslog */
	fromlen = sizeof (from);
	if (getpeername(0, &from, &fromlen) < 0) {
		fprintf(stderr, "%s: ", argv[0]);
		perror("getpeername");
		_exit(1);
	}
	if (setsockopt(0, SOL_SOCKET, SO_KEEPALIVE, &on, sizeof (on)) < 0) {
		syslog(LOG_WARNING, "setsockopt (SO_KEEPALIVE): %m");
	}
	doit(0, &from);
}

int	cleanup();
char*	line;
char**	env = NULL;

struct winsize win = { 0, 0, 0, 0 };

doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	int i, p, t, child, oldmask, on = 1;
	register struct hostent *hp;
	struct hostent hostent;
	char	c;

	DBG_FPRINTF((dbg, "rlogind: entry to doit\n"));

	fromp->sin_port = ntohs((u_short)fromp->sin_port);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		/*
		 * Only the name is used below.
		 */
		hp = &hostent;
		hp->h_name = inet_ntoa(fromp->sin_addr);
	}
	if (fromp->sin_family != AF_INET) fatal(f, "Permission denied");

	/* if we're on a reserved port,
	 * this must be inetd-mediated rlogin service.
	 * Thus, we're talking to an rcmd-style rlogin, like 4.3bsd.
	 */
	if (fromp->sin_port < IPPORT_RESERVED) {
		/* 4.3bsd's rcmd handshakes for socket diagnostic: "test123" */
		alarm(60);
		read(f, &c, 1);
		if (c != 0) exit(1);
		alarm(0);
		write(f, "", 1);
	}
	for (c = 'p'; c <= 's'; c++) {
		struct stat stb;
		line = "/dev/ptyXX";
		line[strlen("/dev/pty")] = c;
		line[strlen("/dev/ptyp")] = '0';
		if (stat(line, &stb) < 0)
			break;
		for (i = 0; i < 16; i++) {
			line[strlen("/dev/ptyp")] = "0123456789abcdef"[i];
			p = open(line, 2);
			if (p > 0)
				goto gotpty;
		}
	}
	fatal(f, "Out of ptys");
	/*NOTREACHED*/

	/* we initialize the window-size to 0's, so that if
	 * rlogin never sends real window-sizes to us,
	 * TERMCAP's values will apply.
	 */
gotpty:
	(void) ioctl(p, TIOCSWINSZ, &win);

	line[strlen("/dev/")] = 't';
#ifdef DEBUG
	{ int tt = open("/dev/tty", 2);
	  if (tt > 0) {
		ioctl(tt, TIOCNOTTY, 0);
		close(tt);
	  }
	}
#endif
	t = open(line, 2);
	if (t < 0)
		fatalperror(f, line, errno);
	{ struct sgttyb b;
	  gtty(t, &b); b.sg_flags = RAW|ANYP; stty(t, &b);
	}

	/* pty is ready, so now we can handle rlogin's environment-pass.
	 * netfbuf is used by the oob-handlers (q.v.),
	 * and by flush_to_oob_mark.
	 */
	initbuf(&netfbuf, 1024);
	netf = f;
	signal(SIGQUIT, cleanup);   /* oob handlers may signal SIGQUIT */

	/* rlogin may send us, out-of-band,
	 * announcements of incoming environment var's & window-sizes.
	 * we need to catch such oob-msgs.
	 */
	oldmask = sigblock(sigmask(SIGURG));
	fcntl(f, F_SETOWN, getpid());	/* parent process (protocol) gets oob */

#ifdef ENV
	sleep(10);
	env = req_and_await_env(f, p);	/* initiate env-passing protocol */
					/* ( this call unblocks SIGURGS) */
#endif ENV

	request_winsiz(f, p);		/* initiate window-size protocol */
	sigsetmask(oldmask);		/* accept client's response */

	/* both parent & child die on i/o errors,
	 * which the pty supplies readily,
	 * so no SIGCHLD handling or wait() calls are necessary.
	 */
	signal(SIGCHLD, cleanup);
	DBG_FPRINTF((dbg, "doit: before fork\n"));
	child = fork();
	if (child < 0)
		fatalperror(f, "", errno);
	if (child == 0) {
		close(f), close(p);
		dup2(t, 0), dup2(t, 1), dup2(t, 2);
		close(t);
		execle("/usr/etc/login.erl", "login.erl", "-p", "-k",
		 	hp->h_name, 0, env);
		fatalperror(2, "/bin/login", errno);
		/*NOTREACHED*/
	}
	close(t);
	ioctl(f, FIONBIO, &on);
	ioctl(p, FIONBIO, &on);
	ioctl(p, TIOCPKT, &on);

	signal(SIGTSTP, SIG_IGN);
	setpgrp(0, 0);
	protocol(f, p);
	cleanup();
} /* end doit */

#define NZERO(i) ((i)!=0)
#define  ZERO(i) ((i)==0)

/*
 * rlogin "protocol" machine.
 */
protocol(f, p)
	int f, p;
{
	struct fifo fbuf, pbuf, pstat;
	register pcc = 0, fcc = 0;

	initbuf(&fbuf, 1024);
	initbuf(&pbuf, 1024);
	initbuf(&pstat, 1);

	for (;;) {
		int ibits, obits, ebits;

		obits = NZERO(fcc)<<p | NZERO(pcc)<<f;
		ibits =  ZERO(fcc)<<f |  ZERO(pcc)<<p;
		ebits = (1<<p);

		if (select(16, &ibits, &obits, &ebits, 0) < 0)
			if (errno != EINTR) fatalperror(f, "select", errno);
			else continue;

		if (ibits == 0 && obits == 0 && ebits == 0) {
			sleep(5); /* shouldn't happen... */
			continue;
		}
		if (ebits & (1<<p)) {
			fillbuf(p, &pstat);	/* failure ok */
			if (pty_stat(&pstat, f) & TIOCPKT_FLUSHWRITE) {
				pcc = 0;
				ibits &= ~(1<<p);
			}
		}
		if (ibits & (1<<f)) {
			if (fillbuf(f, &fbuf)  == READ_FAILED) return;
			fcc = fbuf.cc;
		}
		if (obits & (1<<p) && fcc > 0) {
			if (drainbuf(&fbuf, p) == WRITE_FAILED)
				DBG_FPRINTF((dbg, "rfail: ibits=%x, obits=%x\n",
					ibits,obits));
			fcc = fbuf.cc;
		}
		if (ibits & (1<<p)) {	/* if child is dead, we die here */
			if (fillbuf(p, &pbuf)  == READ_FAILED) return;
			pty_stat(&pbuf, f); /* get rid of control byte */
			pcc = pbuf.cc;
		}
		if (obits & (1<<f) && pcc > 0) {
			if (drainbuf(&pbuf, f) == WRITE_FAILED) sleep(5);
			pcc = pbuf.cc;
		}
	}
} /* end protocol */

cleanup()
{
	DBG_FCLOSE (dbg);
	rmut();
#if defined(_AIX) && defined(i386)
	_vhangup();
#else
	vhangup();		/* XXX */
#endif
	shutdown(netf, 2);
	exit(1);
}

#include <utmp.h>

struct	utmp wtmp;
char	wtmpf[]	= "/usr/adm/wtmp";
char	utmpf[] = "/etc/utmp";
#define SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define SCMPN(a, b)	strncmp(a, b, sizeof(a))

rmut()
{
	register int f;
	int found = 0;
	struct utmp *u, *utmp;
	int nutmp;
	struct stat statbf;

	f = open(utmpf, O_RDWR);
	if (f >= 0) {
		fstat(f, &statbf);
		utmp = (struct utmp *)malloc(statbf.st_size);
		if (!utmp)
			syslog(LOG_ERR, "utmp malloc failed");
		if (statbf.st_size && utmp) {
			nutmp = read(f, utmp, statbf.st_size);
			nutmp /= sizeof(struct utmp);
		
			for (u = utmp ; u < &utmp[nutmp] ; u++) {
				if (SCMPN(u->ut_line, line+5) ||
				    u->ut_name[0]==0)
					continue;
				lseek(f, ((long)u)-((long)utmp), L_SET);
				SCPYN(u->ut_name, "");
				SCPYN(u->ut_host, "");
				time(&u->ut_time);
				write(f, (char *)u, sizeof(wtmp));
				found++;
			}
		}
		close(f);
	}
	if (found) {
		f = open(wtmpf, O_WRONLY|O_APPEND);
		if (f >= 0) {
			SCPYN(wtmp.ut_line, line+5);
			SCPYN(wtmp.ut_name, "");
			SCPYN(wtmp.ut_host, "");
			time(&wtmp.ut_time);
			write(f, (char *)&wtmp, sizeof(wtmp));
			close(f);
		}
	}
	chmod(line, 0666);
	chown(line, 0, 0);
	line[strlen("/dev/")] = 'p';
	chmod(line, 0666);
	chown(line, 0, 0);
}
