/* Copyright (c) 1986 Massachusetts Institute of Technology

   Permission to use, copy, modify, and distribute this program
   for any purpose and without fee is hereby granted, provided
   that this copyright and permission notice appear on all copies
   and supporting documentation, the name of M.I.T. not be used
   in advertising or publicity pertaining to distribution of the
   program without specific prior permission, and notice be given
   in supporting documentation that copying and distribution is
   by permission of M.I.T.  M.I.T. makes no representations about
   the suitability of this software for any purpose.  It is pro-
   vided "as is" without express or implied warranty.
*/
/*
 *	$Source: /mit/kerberos/src/appl/knetd/RCS/parse.c,v $
 *	$Header: parse.c,v 4.1 87/09/01 16:19:58 steiner Exp $
 */

#ifndef lint
static char *rcsid_parse_c = "$Header: parse.c,v 4.1 87/09/01 16:19:58 steiner Exp $";
#endif lint
/*
 * parse.c: routines to read in the config file
 * The config file structure is identical to that of inetd.conf.
 * However, it ignores several of the entries in the table.
 * The table has one entry per line, with comment lines beginning with '#'
 * the components of the line need only be separated by whitespace (space/tab)
 * contents:
 *
 * service name
 * (unused)
 * connection type (tcp ONLY)
 * (unused)
 * username to run as
 * image of daemon to run
 * arg0 to pass to  daemon
 */

#include <pwd.h>
#include <syslog.h>
#include <ctype.h>
#include <stdio.h>
#include <netdb.h>
#include <errno.h>
#include "knetd.h"

extern int errno;
extern int debug;
char *getline(), *word(), *copystring(), *malloc(), *strcpy();

FILE *configfile = NULL;

setconfig(file)
char *file;
{
    if (configfile != NULL)
      (void) fclose(configfile);
    if ((configfile = fopen(file, "r")) == NULL) {
	if (debug)
	  printf("error opening config file %s, %d\n", file, errno);
	syslog(LOG_WARNING, "error opening config file %s:%m", file);
	exit(1);
    }
}

endconfig()
{
    (void) fclose(configfile);
}


static struct knet_entry newent;

/* fill in a structure from the file and return a pointer to it.  The
   structure itself is static, but the strings it points to are not. */
struct knet_entry *getconfigent()
{
    struct passwd *pwent;
    struct protoent *proto;
    char *line;
    char *disposable;

    if (configfile == NULL) setconfig(CONFIG); /* open file */

    line = getline(configfile);		/* get next line */

    if (line == NULL) return((struct knet_entry *)NULL); /* no line; done */

    if (words(line) < NUM_FIELDS) { /* not enough fields, something's wrong */
	if (debug)
	  printf("bad line in config file: %s\n", line);
	syslog(LOG_WARNING, "bad line in config file: %s", line);
	return(getconfigent());		/* get next line, ignore error */
    }

    newent.kn_name = copystring(word(&line)); /* service name */

    (void) word(&line);			/* skip 2nd field */

    /* get protcol */
    if ((proto = getprotobyname(disposable = word(&line))) != NULL)
      newent.kn_type = proto->p_proto;
    else {
	if (debug)
	  printf("unknown protocol type %s\n",disposable);
	syslog(LOG_WARNING, "unknown protocol type %s", disposable);
	free(newent.kn_name);		/* release storage */
	return(getconfigent());		/* bad line, ignore and go on */
    }

    (void) word(&line);			/* skip 4th field */

    /* user name to run daemon as */
    if ((pwent = getpwnam(disposable = word(&line))) != NULL)
      newent.kn_uid = pwent->pw_uid;
    else {
	if (debug)
	  printf("unknown username %s\n",disposable);
	syslog(LOG_WARNING, "unknown username %s", disposable);
	free(newent.kn_name);		/* release storage */
	return(getconfigent());		/* bad line, ignore and go on */
    }

    /* get pathname of image */
    newent.kn_pathname = copystring(word(&line));

    /* get arg0 */
    newent.kn_arg0 = copystring(word(&line));

    return(&newent);
}

static char str[MAX_LINELENGTH];

/* get a line from file referenced by filep.  Ignore lines that begin with # */

char *getline(filep)
FILE *filep;
{
    char *bad;
    do
      bad = fgets(str, MAX_LINELENGTH, filep);
    while (bad != NULL && str[0] == '#');
    if (bad == NULL) return(NULL);
    return(str);
}

words(line)				/* count words in line */
char *line;
{
    register int i = 0;
    register char *cp = line;

    for (; *cp != '\0'; i++, cp++)
      while (!isspace(*cp) && *cp != '\0') cp++;
    return(i);
}

/* return pointer to next word in line, and advance *line to be past it */

char *word(line)
char **line;
{
    register char *cp = *line;

    while (isspace(*cp)) cp++; /* advance past any whitespace */
    *line = cp;

    /* advance past real characters */
    while (!isspace(**line) && **line != '\0') (*line)++;

    **line = '\0';		       /* replace trailing space with a null */
    (*line)++;			       /* and advance past it for next time */
    return(cp);
}


/* copy string to non-volatile storage */

char *copystring(str)
char *str;
{
    char *cpm;

    /* strlen() + 1 since we need room for the null trailer */
    cpm = (char *) malloc((unsigned) (strlen(str) + 1));

    (void) strcpy(cpm, str);
    return(cpm);
}
