/*
 *	$Source: /mit/kerberos/src/appl/tftp/RCS/srvr_log.c,v $
 *	$Author: steiner $
 *	$Locker:  $
 *	$Log:	srvr_log.c,v $
 * Revision 4.2  88/03/16  18:37:08  steiner
 * Removed improper #.
 * Programmer: wesommer.
 * Auditor: jtkohl.
 * 
 * Revision 4.1  87/09/01  16:33:23  steiner
 * No change; starting version 4.
 * 
 * Revision 2.1  85/12/12  10:53:49  bcn
 * Change majore version number to 2.
 * 
 * Revision 1.1  85/06/07  21:45:04  martillo
 * Initial revision
 * 
 */

#ifndef lint
static char *rcsid_srvr_log_c = "$Header: srvr_log.c,v 4.2 88/03/16 18:37:08 steiner Exp $";
#endif	lint

/* EMACS_MODES: c !fill */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	"notice.h"


/* This file contains the routines that log error messages for the
 * server version of tftp.  It is in a separate file because these
 * routines differ in the server and user versions of the program.
 */

#include	<stdio.h>
#include	<sys/types.h>


cn_log (estring, ecode, arg)

/* Log the message estring on the standard error, preceeded by
 * process id and date/time.  The ecode argument is the tftp error code;
 * arg is an argument to printf for the estring.
 *
 * Arguments:
 */

char	*estring;			/* printf format error message */
int	ecode;				/* tftp error code */
caddr_t	arg;				/* general purpose argument */
{
	time_t	now;			/* current time */
	
	time (&now);
	fprintf (stderr, "\nPid %d %sCode = %d\n",
		getpid (), ctime (&now), ecode);
	fprintf (stderr, estring, arg);
	fflush (stderr);
}


cn_inform (msg, arg)

/* Log an informative message (as opposed to an error message).  This
 * is a separate routine because the user doesn't want to see these
 * messages.
 *
 * Arguments:
 */

char	*msg;				/* error message */
caddr_t	arg;				/* argument to error message */
{
	fprintf (stderr, msg, arg);
	fflush (stderr);
}
