#include	<stdio.h>
#include	<errno.h>
#include	<sys/types.h> 
#include	<sys/stat.h>
#include	<sys/file.h>

#define	R_TKT_FIL	0
#define	W_TKT_FIL	1


#define NO_TKT_FIL	42
#define TKT_FIL_ACC	17
#define TKT_FIL_OPN	2
#define	TKT_FIL_LCK	3
#define TKT_FIL_LST	5

extern errno;

static fd;

tkf_init(tkf_name, rw)
char *tkf_name;
{
	int i, wflag;
	struct stat stat_buf;
	unsigned o_flags;

	switch (rw) {
	case R_TKT_FIL:
		wflag = 0;
		break;
	case W_TKT_FIL:
		wflag = 1;
		break;
	default:
		fprintf(stderr, "tkf_init: illegal parameter\n");
			exit (-1);
	}
	if (lstat(tkf_name, &stat_buf) < 0) {
		perror("lstat");
		switch(errno) {
			case ENOENT:
				return NO_TKT_FIL;
			default:
				return TKT_FIL_ACC;
		}
	}
	o_flags = wflag ? O_APPEND : O_RDONLY;
	if ((fd = open(tkf_name, o_flags)) < 0)
		return TKT_FIL_ACC;
	if (flock(fd, (wflag ? LOCK_EX : LOCK_SH) | LOCK_NB) < 0)
		return TKT_FIL_LCK;
	printf("%s is open for %s\n", tkf_name, wflag ? "writing" :
		"reading");
}

main()
{
	int k_errno;

	k_errno = tkf_init("x", R_TKT_FIL);
printf("x for R returned %d\n", k_errno);

	k_errno = tkf_init("a", R_TKT_FIL);
printf("a for R returned %d\n", k_errno);

	k_errno = tkf_init("a", R_TKT_FIL);
printf("a for R returned %d\n", k_errno);

	k_errno = tkf_init("b", W_TKT_FIL);
printf("b for W returned %d\n", k_errno);

	k_errno = tkf_init("a", W_TKT_FIL);
printf("a for W returned %d\n", k_errno);

}
