/*
 * Listener loop for subsystem library libss.a.
 *
 *	$Header: /afs/net.mit.edu/project/krb4/src/util/ss/RCS/listen.c,v 1.2 92/12/02 00:21:46 tytso Exp $
 *	$Locker:  $
 * 
 * Copyright 1987 by MIT Student Information Processing Board
 *
 * For copyright information, see mit-sipb-copyright.h.
 */
#include "mit-sipb-copyright.h"
#include "ss_internal.h"
#include <signal.h>
#include <strings.h>

#ifndef	lint
static char rcs_id[] = "$Header: /afs/net.mit.edu/project/krb4/src/util/ss/RCS/listen.c,v 1.2 92/12/02 00:21:46 tytso Exp $";
#endif

static ss_data *current_info;

static int			/* for lint */
print_prompt()
{
     /* should also do ioctl to fix tty modes here */
     (void) fputs(current_info->prompt, stdout);
     (void) fflush(stdout);
}

void
ss_listen (sci_idx, code_ptr)
int sci_idx;
int *code_ptr;
{
     register int n_read;
     register char *cp;
     register int (*func)();
     register ss_data *info;
     char input[BUFSIZ];
     char buffer[BUFSIZ];
     char *end = buffer;
     ss_data *old_info = current_info;
     
     current_info = info = ss_info(sci_idx);
     info->abort = 0;
     while(!info->abort) {
	  print_prompt();
	  *end = '\0';
	  func = signal(SIGCONT, print_prompt);
	  n_read = read(0, input, BUFSIZ);
	  (void) signal(SIGCONT, func);
	  if (n_read == 0 || input[n_read-1] != '\n') {
	       *code_ptr = SS_ET_EOF;
	       return;
	  }
	  if (n_read == 1)
	       continue;
	  end = input + n_read - 1;
	  if ((cp = index(input, '\n')) != (char *)NULL)
	       *cp = '\0';
	  ss_execute_line (sci_idx, input, code_ptr);
	  if (*code_ptr == SS_ET_COMMAND_NOT_FOUND) {
	       register char *c = index(input, ' ');
	       if (c)
		    *c = '\0';
	       /* some sort of inline strcpy/strcat would be nice.. */
	       strcpy(buffer, "Unknown request \"");
	       strcat(buffer, input);
	       strcat(buffer, "\".  Type '?' for a request list.");
	       ss_perror(sci_idx, 0, buffer);
	  }
	  fputc('\n', stdout);
     }
     *code_ptr = 0;
     current_info = old_info;
     return;
}

void
ss_abort_subsystem(sci_idx, code)
     int sci_idx;
{
     ss_info(sci_idx)->abort = 1;
     ss_info(sci_idx)->exit_status = code;
     
}

FUNCTION_TYPE
ss_quit(argc, argv, sci_idx)
     int argc;
     char **argv;
     int sci_idx;
{
     ss_abort_subsystem(sci_idx, 0);
}
