/*
 * Pager: Routines to create a "more" running out of a particular file
 * descriptor.
 *
 * Copyright 1987 by MIT Student Information Processing Board
 *
 * For copyright information, see mit-sipb-copyright.h.
 */
#include "mit-sipb-copyright.h"
#include <stdio.h>

static char MORE[] = "more";
extern char *_ss_pager_name;
extern char *getenv();
extern int errno;
     
int ss_pager_create() 
{
     int filedes[2];
     register int i;
     
     if (_ss_pager_name == (char *)NULL) {
	  if ((_ss_pager_name = getenv("PAGER")) == (char *)NULL)
	       _ss_pager_name = MORE;
     }
     if (pipe(filedes) != 0)
	  return(-1);
     
     switch(fork()) {
     case -1:
	  return(-1);
     case 0:
	  /*
	   * Child; dup read half to 0, close all but 0, 1, and 2
	   */
	  if (dup2(filedes[0], 0) == -1)
	       exit(1);
	  for (i = 3; i < 32; i++)
	       (void) close(i);
	  (void) execlp(_ss_pager_name, _ss_pager_name, (char *) NULL);
	  exit(errno);
     default:
	  /*
	   * Parent:  close "read" side of pipe, return
	   * "write" side.
	   */
	  (void) close(filedes[0]);
	  return(filedes[1]);
     }
}
