/*
 * Copyright 1987 by MIT Student Information Processing Board
 *
 * For copyright information, see mit-sipb-copyright.h.
 */

#ifndef _SS
#define _SS

extern int errno;

/*
 * should logically be "void", but some compilers can't handle
 * it properly.  since int will work as well (just ignore the
 * return value), we can use it here...
 */
#define	FUNCTION_TYPE int
#define	FUNCTION_TYPE_NAME "int"

typedef struct {
	char **command_names;	/* whatever */
	FUNCTION_TYPE (*function)(); /* foo */
	char *info_string;	/* NULL */
	int flags;		/* 0 */
} ss_request_entry;

typedef struct {
	int version;
	ss_request_entry *requests;
} ss_request_table;

#define SS_RQT_TBL_V2	2

typedef struct {		/* DEFAULT VALUES */
	int version;		/* SS_RP_V1 */
	FUNCTION_TYPE (*unknown)(); /* call for unknown command */
	int allow_suspend;
	int catch_int;
} ss_rp_options;

#define SS_RP_V1 1

#define SS_OPT_DONT_LIST	0x0001
#define SS_OPT_DONT_SUMMARIZE	0x0002

FUNCTION_TYPE ss_help();
char *ss_current_request();
char *ss_name();
void ss_perror();
void ss_abort_subsystem();
#endif _SS

/* ss_err.h follows here */
