.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rshd.8c	6.3 (Berkeley) 5/24/86
.\"
.TH KRSHD 8C "Kerberos Version 5.0" "MIT Project Athena"
.SH NAME
krshd \- kerberized remote shell server
.SH SYNOPSIS
.B /usr/etc/krshd -kKrR
.SH DESCRIPTION
.I Krshd
is the server for the 
.IR rcmd (3X)
routine and, consequently, for the
.IR rsh (1C)
program.  The server provides remote execution facilities
with authentication based on privileged port numbers from trusted hosts.
.PP
The
.I krshd
server is invoked by \fIinetd(8c)\fP when it receives a connection
on the port indicated in /etc/inetd.conf.  A typical /etc/inetd.conf
configuration line for \fIkrshd\fP might be:

kshell	stream	tcp	nowait	root	/krb5/sbin/krshd	krshd -K

When a service request is received, the follow protocol is initiated:

.IP 1) 
Authentication is checked
.IP 2)
Authorization is checked via the access-control files \fI.k5login\fP 
and \fI.rhosts\fP in the user's home directory.
.IP 3)
A null byte is returned on the initial socket
and the command line is passed to the normal login
shell of the user.  The
shell inherits the network connections established
by
.IR krshd .

\fIKrshd\fP can be configured either by command-line arguments passed
by \fIinetd(8)\fP,  
or by the name of the daemon. If command-line arguments are present, they 
take priority.  The options are:

.IP \fB\-k\fP 10
Check authorization in ~/.k5login.

.IP \fB\-K\fP
Similar to \fb\-k\fP except that the authorization check must succeed
inorder for the login to succeed.

.IP \fB\-r\fP 
Check authorization in ~/.rhosts.

.IP \fB\-K\fP
Similar to \fb\-r\fP except that the authorization check must succeed
inorder for the login to succeed.

.PP
If no command-line arguments are present, then the presence of the 
letters kKrR in the program-name before "shd" determine the 
behaviour of the program exactly as with the command-line arguments.
.PP
If the \fB\-r\fP or \fB\-R\fP options are used, the client must
connect from a privileged port.
.PP
\fIKrshd\fP supports four options which may be used for testing:

.IP \fB\-S\ srvtab\fP 10
Set the \fIsrvtab\fP file to use.

.IP \fB\-M\ realm\fP
Set the Kerberos realm to use.

.IP \fB\-A\fP
Don't allocate a reserved port for the stderr connection.

.IP \fB\-P\ path\fP
Use the argument to find the Kerberos binaries.  Normally a compiled
in argument is used.
.SH DIAGNOSTICS
Except for the last one listed below,
all diagnostic messages
are returned on the initial socket,
after which any network connections are closed.
An error is indicated by a leading byte with a value of
1 (0 is returned in step 3 above upon successful completion
of all the steps prior to the execution of the login shell).
.PP
.B ``locuser too long''
.br
The name of the user on the client's machine is
longer than 16 characters.
.PP
.B ``remuser too long''
.br
The name of the user on the remote machine is
longer than 16 characters.
.PP
.B ``command too long ''
.br
The command line passed exceeds the size of the argument
list (as configured into the system).
.PP
.B ``Login incorrect.''
.br
No password file entry for the user name existed.
.PP
.B ``No remote directory.''
.br
The 
.I chdir
command to the home directory failed.
.PP
.B ``Permission denied.''
.br
The authentication procedure described above failed.
.PP
.B ``Can't make pipe.''
.br
The pipe needed for the 
.BR stderr ,
wasn't created.
.PP
.B ``Try again.''
.br
A
.I fork
by the server failed.
.PP
.B ``<shellname>: ...''
.br
The user's login shell could not be started.  This message is returned
on the connection associated with the
.BR stderr ,
and is not preceded by a flag byte.
.SH SEE ALSO
rshd(8C), rsh(1C),
rcmd(3X)
.SH BUGS
A facility to allow all data exchanges to be encrypted should be
present.
.PP
A more extensible protocol should be used.
