/* $Id: krb_locl.h,v 1.14 1996/08/18 23:22:49 assar Exp $ */

#ifndef __krb_locl_h
#define __krb_locl_h

#include "config.h"
#include "protos.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <stdarg.h>

#include <errno.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif /* !HAVE_SYS_TIME_H */
#endif /* !TIME_WITH_SYS_TIME */

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_ARPA_NAMESER_H
#include <arpa/nameser.h>
#endif
#ifdef HAVE_RESOLV_H
#include <resolv.h>
#endif

#include <krb.h>
#include <prot.h>

/* --- */

/* Globals! */
#ifndef KRB_NDEB
extern int krb_debug;
extern int krb_ap_req_debug;
#endif

/* Utils */
char *pkt_cipher __P((KTEXT));

int new_log __P((time_t, char *));

char *month_sname __P((int));
int fgetst __P((FILE *, char *, int));

int k_name_to_name(const char *, char *);

void encrypt_ktext(KTEXT cip, des_cblock *key, int encrypt);
int kdc_reply_cred(KTEXT cip, CREDENTIALS *cred);
int kdc_reply_cipher(KTEXT reply, KTEXT cip);

int krb_get_int (void *from, u_int32_t *to, int size, int lsb);
int krb_put_int(u_int32_t from, void *to, int size);
int krb_get_address(void *from, u_int32_t *to);
int krb_put_address(u_int32_t addr, void *to);
int krb_put_string(char *from, void *to);
int krb_get_string(void *from, char *to);
int krb_get_nir(void *from, char *name, char *instance, char *realm);
int krb_put_nir(char *name, char *instance, char *realm, void *to);

int krb_check_tm (struct tm);

#endif /*  __krb_locl_h */
