// OptDlg.cpp
// David Aylesworth

#include "stdafx.h"
#include "WinKey.h"
#include "KeyDlg.h"
#include "OptDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CKeyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog

COptionsDlg::COptionsDlg(CKeyDlg* pParent /*=NULL*/)
   : CDialog(COptionsDlg::IDD, pParent)
{
    m_parent = pParent;
   
    //{{AFX_DATA_INIT(COptionsDlg)
    m_autopaste = pParent->m_autopaste;
    m_autocopy = pParent->m_autocopy;
    m_autodecrement = pParent->m_autodecrement;
    m_autoclear = FALSE;
	m_appendcrlf = FALSE;
	//}}AFX_DATA_INIT
}

void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(COptionsDlg)
    DDX_Check(pDX, IDC_CHECK1, m_autopaste);
    DDX_Check(pDX, IDC_CHECK2, m_autocopy);
    DDX_Check(pDX, IDC_CHECK3, m_autodecrement);
    DDX_Check(pDX, IDC_CHECK4, m_autoclear);
	DDX_Check(pDX, IDC_CHECK5, m_appendcrlf);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
    //{{AFX_MSG_MAP(COptionsDlg)
    ON_BN_CLICKED(IDC_SAVE, OnSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

BOOL COptionsDlg::OnInitDialog() 
{
    CDialog::OnInitDialog();

    // copy global flags
    m_autopaste = (BOOL)m_parent->m_autopaste;
    m_autocopy = (BOOL)m_parent->m_autocopy;
    m_autodecrement = (BOOL)m_parent->m_autodecrement;
    m_autoclear = (BOOL)m_parent->m_autoclear;
    m_appendcrlf = (BOOL)m_parent->m_appendcrlf;
    UpdateData(FALSE);
    CheckRadioButton(IDC_MD4, IDC_MD5, IDC_MD4 + m_parent->m_algorithm);
      
    return TRUE;
}

void COptionsDlg::OnCancel() 
{
    CDialog::OnCancel();
}

void COptionsDlg::OnOK() 
{
    UpdateData(TRUE);

    // set global flags   
    m_parent->m_autopaste = (int)m_autopaste;
    m_parent->m_autocopy = (int)m_autocopy;
    m_parent->m_autodecrement = (int)m_autodecrement;
    m_parent->m_autoclear = (int)m_autoclear;
    m_parent->m_appendcrlf = (int)m_appendcrlf;
    m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

    CDialog::OnOK();
}

void COptionsDlg::OnSave()
{
    UpdateData(TRUE);

    // set global flags   
    m_parent->m_autopaste = (int)m_autopaste;
    m_parent->m_autocopy = (int)m_autocopy;
    m_parent->m_autodecrement = (int)m_autodecrement;
    m_parent->m_autoclear = (int)m_autoclear;
    m_parent->m_appendcrlf = (int)m_appendcrlf;
    m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

    // save defaults
    theApp.WriteProfileInt("Settings", "AutoCopy", m_parent->m_autocopy);
    theApp.WriteProfileInt("Settings", "AutoPaste", m_parent->m_autopaste);
    theApp.WriteProfileInt("Settings", "AutoDecrement", m_parent->m_autodecrement);
    theApp.WriteProfileInt("Settings", "AutoClear", m_parent->m_autoclear);
    theApp.WriteProfileInt("Settings", "AppendCRLF", m_parent->m_appendcrlf);
    theApp.WriteProfileString("Settings", "Algorithm", m_parent->m_algorithm ? "MD5" : "MD4");
 
    CDialog::OnOK();
}
