#!/bin/sh
# opieinfo: Print a user's current OPIE sequence number and seed
#
# Portions of this software are Copyright 1995 by Randall Atkinson and Dan
# McDonald, All Rights Reserved. All Rights under this copyright are assigned
# to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
# License Agreement applies to this software.
#
#	History:
#
#	Modified at NRL for OPIE 2.05. Substitute @@KEY_FILE@@.
#       Modified at NRL for OPIE 2.01. Remove hard-coded paths for grep and
#               awk and let PATH take care of it. Substitute for Makefile 
#               variables $(EXISTS) and $(KEY_FILE). Only compute $WHO if 
#               there's a key file. Got rid of grep since awk can do the job
#               itself.
#	Modified at NRL for OPIE 2.0.
#	Written at Bellcore for the S/Key Version 1 software distribution
#		(keyinfo)
#
for i in $*; 
do
	case $i in
		-v)	opiekey -v;
#                       `basename $0`/opiekey -v; ?
			exit 1;;
		-*)	echo "usage: $0 [-h] [-v] [user_name]";
			exit 1;;
	esac
done

if [ @@EXISTS@@ @@KEY_FILE@@ ]
then
	WHO=${1:-`@@WHOAMI@@`}
        awk '/^'$WHO'[ \t]/ {print $2-1,$3}' @@KEY_FILE@@
	exit 0
else
	echo "Can't find key file."
	exit 1
fi
