/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)LL.h	1.5  96/04/29"


#ifndef LL_H
#define LL_H


template <class T>
struct LLnode {			// support struct for LL linked list class
	LLnode *next;
	T data;
};

template <class T>
class LL {			// linked list
protected:
	LLnode<T>* head;
	LLnode<T>* tail;

private:
	LLnode<T>* cur_p;	// cursor
	LLnode<T>* prev_p;	// previous cursor position
	LLnode<T>* next_p;	// next cursor position

public:
	LL(): head(0), tail(0), cur_p(0), prev_p(0), next_p(0) {}
	LL(const LL<T>&);
	~LL() {clear();}
	LL<T>& operator =(const LL<T>& rhs);
	
	void insert(const T&);
	void append(const T&);
	int length();
	void clear();

	T* first();		// set cursor to list head and return it
	T* next();		// advance and return cursor, 0 at end
	T* current();		// return cur_p
	void delete_current();	// iterator safe, follow with next()

// Cursor usage:
//	for (T* p = LL.first(); p; p = LL.next())
//		...	// delete_current() okay
};

template <class T>
LL<T>::LL(const LL<T>& orig)
{
	clear();
	for (LLnode<T>* p = orig.head; p; p = p->next)
		append(p->data);
}

template <class T>
LL<T>& LL<T>:: operator =(const LL<T>& rhs)
{
	if (this != &rhs) {
		clear();
		for (LLnode<T>* p = rhs.head; p; p = p->next)
			append(p->data);
	}
	return (*this);
}

template <class T>
void LL<T>::insert(const T& item)
{
	LLnode<T>* p;

	p = new LLnode<T>;
	p->data = item;
	p->next = head;
	if (head == 0)
		tail = p;
	head = p;
}

template <class T>
void LL<T>::append(const T& item)
{
	LLnode<T>* p;

	p = new LLnode<T>;
	p->data = item;
	p->next = 0;

	if (tail == 0)
		head = p;
	else
		tail->next = p;
	tail = p;
}

template <class T>
int LL<T>::length()
{
	int sum = 0;

	for (LLnode<T>* p = head; p; p = p->next)
		sum++;

	return sum;
}

template <class T>
void LL<T>::clear()
{
	LLnode<T>* p;
	LLnode<T>* next;

	p = head;
	while (p)
	{
		next = p->next;
		delete p;
		p = next;
	}
	head = 0;
	tail = 0;
	cur_p = 0;
	prev_p = 0;
	next_p = 0;
}

template <class T>
T* LL<T>::first() 
{

	if (head == 0)
		return 0;

	prev_p = 0;
	cur_p = head;
	next_p = cur_p->next;

	return &cur_p->data;
}

template <class T>
T* LL<T>::next() 
{

	if (next_p == 0)
		return 0;

	if (cur_p)		// leave prev_p alone if we just deleted cur_p
		prev_p = cur_p;

	cur_p = next_p;
	next_p = next_p->next;
	return &cur_p->data;
}

template <class T>
T* LL<T>::current() 
{

	if (cur_p == 0)
		return 0;

	return &cur_p->data;
}

template <class T>
void LL<T>::delete_current()
{

	if (cur_p)
	{
		if (prev_p)
			prev_p->next = next_p;
		else
			head = next_p;

		if (cur_p == tail)
		{
			if (prev_p)
				tail = prev_p;
			else
				tail = head;
		}

		delete cur_p;
		cur_p = 0;
	}
}

#endif  /* LL_H */

