/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)manualcrl.C	1.5 96/05/30 Sun Microsystems"

#include <unistd.h>
#include "Bstream.h"
#include "Bigint.h"
#include "LL.h"
#include "manualcrl.h"

ManualCRL::ManualCRL(const ManualCRL& rhs)
{
	serialnos = rhs.serialnos;
}

ManualCRL::ManualCRL()
{
}

ManualCRL& ManualCRL::operator =(const ManualCRL& rhs)
{
	if (&rhs != this) {
		serialnos = rhs.serialnos;
	}
	return *this;
}

int
ManualCRL::load(const char *filename) 
{
	char buf[1024];
	FILE *fp;
	serialnos.clear();

	fp = fopen(filename, "r");
	if (fp == NULL)
		return 1;

	while (fgets(buf, 1024, fp)!= NULL) {
		buf[strlen(buf)] = '\0';
		Bigint serialno(buf);
		serialnos.insert(serialno);
	}
	fclose(fp);
	return 0;
}

int 
ManualCRL::store(const char *filename)
{
	String ss;
	FILE *fp;
	int count;
	Bigint *p;

	for (count = 0, p = serialnos.first(); p!=NULL; p=serialnos.next(), 
							count++);
	if (count == 0)  {
		unlink(filename);
		return 0;
	}
	fp = fopen(filename, "w");
	if (fp == NULL)
		return 1;
	for (p = serialnos.first(); p != NULL; p = serialnos.next()) {
		ss = p->getnumstr();
		fputs((const char *)ss, fp);
		fprintf(fp,"\n");
	}
	fclose(fp);
}

void
ManualCRL::add(Bigint &serialno)
{
	if (ispresent(serialno))
		return;
	serialnos.insert(serialno);
}

void
ManualCRL::del(Bigint &serialno)
{

	for ( Bigint *p=serialnos.first(); p != NULL; p = serialnos.next()) {
		if ( *p == serialno)  {
			serialnos.delete_current();
			return;
		}
	}
	return;
}

int 
ManualCRL::ispresent(Bigint &serialno)
{

	for ( Bigint *p=serialnos.first(); p != NULL; p = serialnos.next()) {
		if ( *p == serialno)  {
			return 1;
		}
	}
	return 0;
}

