/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)des_ede_cbc.c	1.18 96/08/07 Sun Microsystems"


/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP include
 */
#include <skip_proto.h>
#include <skip_crypt.h>

#include "des.h"

struct des_ede_cbc_state {
	unsigned long keysched1[16][2];
	unsigned long keysched2[16][2];
	unsigned long keysched3[16][2];
	int pad;
};
#define MODULE_NAME_K2		"des_ede_k2"
char                            des_ede_k2_name[] =    MODULE_NAME_K2 " v1.18";

#define MODULE_NAME_K3		"des_ede_k3"
char                            des_ede_k3_name[] =    MODULE_NAME_K3 " v1.18";

STATIC void *des_ede_cbc_k2_open(char *, u_int, char *, u_int);
STATIC void *des_ede_cbc_k2_open_nopad(char *,u_int, char *, u_int);
STATIC void *des_ede_cbc_k3_open(char *, u_int, char *, u_int);
STATIC void *des_ede_cbc_k3_open_nopad(char *,u_int, char *, u_int);

STATIC void des_ede_cbc_k2_close(void *);
STATIC void des_ede_cbc_k3_close(void *);

STATIC void endes_ede_cbc_v1(void *, char *, u_int *, char *, char *, u_int,
					u_char * );
STATIC void dedes_ede_cbc_v1(void *, char *, u_int *, char *, char *, u_int,
					u_char * );
STATIC void endes_ede_cbc(void *, char *, u_int *, char *, char *, u_int, 
					u_char * );
STATIC void dedes_ede_cbc(void *, char *, u_int *, char *, char *, u_int,
					u_char * );

STATIC unsigned int des_ede_cbc_outlen(	u_int);


int			des_ede_k2_busy = 0;
int			des_ede_k3_busy = 0;

/*
 * module number - this is used to install the module in the
 * table of cryptors used by the screen
 */
const unsigned int	des_ede_k2_id = 5; /* DES_EDE_CBC_K2 */
const unsigned int	des_ede_k3_id = 6; /* DES_EDE_CBC_K3 */

const   skip_cryptor_t		des_ede_k2_module_v1 = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K2,			/* name */
	des_ede_cbc_k2_open,		/* open */
	des_ede_cbc_k2_close,		/* close */
	endes_ede_cbc_v1,		/* encrypt */
	dedes_ede_cbc_v1,		/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	16,				/* kp_len */
	16,				/* ekp_len 16 bytes for 2 Keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER|		/* flags */
		SKIP_VER1,
	0,				/* kij */
	SKIP_DES_EDE_K2			/* kp */
};

const   skip_cryptor_t		des_ede_k2_nopad_module_v1 = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K2,			/* name */
	des_ede_cbc_k2_open_nopad,	/* open */
	des_ede_cbc_k2_close,		/* close */
	endes_ede_cbc_v1,		/* encrypt */
	dedes_ede_cbc_v1,		/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	16,				/* kp_len */
	16,				/* ekp_len 16 bytes for 2 Keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER|		/* flags */
		SKIP_VER1,
	SKIP_DES_EDE_K2,		/* Not a valid kij algorithm */
	0				/* Kp algorithm */
};

const   skip_cryptor_t		des_ede_k3_module_v1 = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K3,			/* name */
	des_ede_cbc_k3_open,		/* open */
	des_ede_cbc_k3_close,		/* close */
	endes_ede_cbc_v1,		/* encrypt */
	dedes_ede_cbc_v1,		/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	24,				/* kp_len */
	24,				/* ekp_len 24 for 3 keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER|		/* flags */
		SKIP_VER1,
	0,				/* kij */
	SKIP_DES_EDE_K3			/* kp */
};

const   skip_cryptor_t		des_ede_k3_nopad_module_v1 = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K3,			/* name */
	des_ede_cbc_k3_open_nopad,	/* open */
	des_ede_cbc_k3_close,		/* close */
	endes_ede_cbc_v1,		/* encrypt */
	dedes_ede_cbc_v1,		/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	24,				/* kp_len */
	24,				/* ekp_len 24 for 3 keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER|
		SKIP_VER1,		/* flags */
	SKIP_DES_EDE_K3,		/* kij algorithm */
	0				/* kp algorithm */
};

const   skip_cryptor_t		des_ede_k3_nopad_module = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K2,			/* name */
	des_ede_cbc_k3_open_nopad,	/* open */
	des_ede_cbc_k3_close,		/* close */
	endes_ede_cbc_v1,		/* encrypt */
	dedes_ede_cbc_v1,		/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	24,				/* kp_len */
	24,				/* ekp_len 16 bytes for 2 Keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER,		/* flags */
	SKIP_KIJ_DES_EDE_K3,		/* Not a valid kij algorithm */
	0				/* Kp algorithm */
};

const   skip_cryptor_t		des_ede_k3_module = {
	SKIP_CRYPTOR_V1,		/* binary version */
	MODULE_NAME_K3,			/* name */
	des_ede_cbc_k3_open,		/* open */
	des_ede_cbc_k3_close,		/* close */
	endes_ede_cbc,			/* encrypt */
	dedes_ede_cbc,			/* decrypt */
	des_ede_cbc_outlen,		/* getoutputlen */
	24,				/* kp_len */
	24,				/* ekp_len 24 for 3 keys */
	8,				/* blocksize */
	8,				/* mid_len */
	SKIP_BLOCK_CIPHER,		/* flags */
	0,				/* kij */
	SKIP_CRYPT_DES_EDE_K3		/* kp */
};


/*
 * external functions...
 */
extern void endes_ede_ecb();
extern void dedes_ede_ecb();

static
void *
des_ede_cbc_k3_open1(int pad, char *keyp, unsigned int keylen, 
					 char *ivp, unsigned int ivlen)
{
	struct des_ede_cbc_state *cs;
 	if (keylen != 24) {
		printf("des_ede_cbc_open: keylen = %d != 24\n", keylen);
		return (0);
	}
	cs = (struct des_ede_cbc_state *)
			SYSMEM_ALLOC(sizeof(struct des_ede_cbc_state));
	des_ede_k3_busy++;
	if (cs == (void *)0)
		return cs;
	cs->pad=pad;
	skip_setkey(cs->keysched1, (unsigned char *) &keyp[0]);
	skip_setkey(cs->keysched2, (unsigned char *) &keyp[8]);
	skip_setkey(cs->keysched3, (unsigned char *) &keyp[16]);
	return (cs);
}

STATIC
void *
des_ede_cbc_k2_open1(int pad, char *keyp, unsigned int keylen, char *ivp, 
					  unsigned int ivlen)
{
	struct des_ede_cbc_state *cs;
 	if (keylen != 16) {
		printf("des_ede_cbc_open: keylen = %d != 16\n", keylen);
		return (0);
	}
	cs = (struct des_ede_cbc_state *)
			SYSMEM_ALLOC(sizeof(struct des_ede_cbc_state));
	des_ede_k2_busy++;
	if (cs == (void *)0)
		return cs;
	cs->pad=pad;
	skip_setkey(cs->keysched1, (unsigned char *) &keyp[0]);
	skip_setkey(cs->keysched2, (unsigned char *) &keyp[8]);
	skip_setkey(cs->keysched3, (unsigned char *) &keyp[0]);

	return (cs);
}

STATIC
void *
des_ede_cbc_k2_open(char  *keyp, unsigned int keylen, char *ivp, 
					unsigned int ivlen)
{
	return des_ede_cbc_k2_open1(1,keyp,keylen,ivp,ivlen);
}

STATIC
void *
des_ede_cbc_k3_open(char  *keyp, unsigned int keylen, char *ivp, 
					unsigned int ivlen)
{
	return des_ede_cbc_k3_open1(1,keyp,keylen,ivp,ivlen);
}

STATIC
 void *
des_ede_cbc_k2_open_nopad(char  *keyp, unsigned int keylen, char *ivp, 
							unsigned int ivlen)
{
	return des_ede_cbc_k2_open1(0,keyp,keylen,ivp,ivlen);
}

STATIC
 void *
des_ede_cbc_k3_open_nopad(char  *keyp, unsigned int keylen, char *ivp, 
							unsigned int ivlen)
{
	return des_ede_cbc_k3_open1(0,keyp,keylen,ivp,ivlen);
}

STATIC
unsigned int
des_ede_cbc_outlen(unsigned int inlen)
{
/*
	XXX assume padded for now.
	if (des_ede_nopad){
		if (inlen % 8)
			return -1;
		else
			return inlen;	
	}
*/
	return (inlen + 8);
}

static char all_8_pad_block[] = 
	{ 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 };


STATIC
void
endes_ede_cbc_v1(void *cs, char *in, u_int *lenp, char *out, char *iv, 
			u_int ivlen, u_char *payload)

{
	char ecbio[8];
	char block[8];
	char pad;
	int i,j, mod8;
	unsigned long *ks1, *ks2, *ks3;
			
	int len = *lenp;
	if (len == 0)
		return;
	ks1 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched1;
	ks2 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched2;
	ks3 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched3;

	mod8 = (len & 0x07);	/* technically this is (len % 8) */

	if (mod8 && ! ((struct des_ede_cbc_state *)cs)->pad)
		return;
	if (len < 8 ) {
		/* 
		 * First, and only block processing 
		 */
		BCOPY((caddr_t)in, (caddr_t)block, len);
		pad = 8 - mod8;
		for (j = 0; j < pad; j++) {
			block[mod8 + j] = pad;
		}
		*(unsigned int *)ecbio = 
				*(unsigned int *)iv ^ 	*(unsigned int *)&block[0];
		*(unsigned int *)(ecbio + 4) = 
				*(unsigned int *)(iv + 4) ^ *(unsigned int *)&block[4];
		endes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);
		*lenp = 8;
		return;
	}
						
	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = 
				*(unsigned int *)iv ^ 	*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) = 
				*(unsigned int *)(iv + 4) ^ *(unsigned int *)&in[4];
	endes_ede_ecb(ks1, ks2, ks3, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);

	for (i = 8; i <= len - 8; i += 8) {
		/* 
		 * Middle blocks processing, no padding required here 
		 */
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&in[i + 4];
		endes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
	}

	/* 
	 * Final block processing, i falls through and is used 
	 */

	if (mod8 != 0) {
		/* 
		 * Need to pad last block upto full 8 bytes 
		 */
		BCOPY((caddr_t)&in[i], (caddr_t)block, len - i);
		pad = 8 - mod8;
		for (j = 0; j < pad; j++) {
			block[mod8 + j] = pad;
		}
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&block[0];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&block[4];
		endes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
		*lenp = len + pad;
	} else {
		/* 
	 	 * length is multiple of 8, add the all 08 pad block 
		 */
		if (! ((struct des_ede_cbc_state *)cs)->pad)
			return;
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&all_8_pad_block[0];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&all_8_pad_block[4];
		endes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
		*lenp = len + 8;
	}
	/*
	 * Set the iv to be the last
	 * encrypted block;
	 */
	BCOPY((caddr_t)&out[i], (caddr_t)iv, 8);
	return;
}

STATIC
void
endes_ede_cbc(void *cs, char *in, u_int *lenp, char *out, 
				char *iv, u_int ivlen, u_char *payload)

{
	char ecbio[8];
	int i;
	unsigned long *ks1, *ks2, *ks3;
	char *buf = in;
			
	int len = *lenp;
	if (len == 0)
		return;

	ks1 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched1;
	ks2 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched2;
	ks3 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched3;

	/* Implement Karn padding */
	while ((len & 0x07) != 6) {
		buf[len]=len;
		len++;
	}	
	buf[len]=len-*lenp;
	len++;
	buf[len]=*payload;
	len++;
	*lenp = len;
	/* 
	 * First block processing 
	 */
	*(unsigned int *)ecbio = *(unsigned int *)iv ^ 	
				*(unsigned int *)&buf[0];
	*(unsigned int *)(ecbio + 4) = *(unsigned int *)(iv + 4) ^ 
				*(unsigned int *)&buf[4];
	endes_ede_ecb(ks1, ks2, ks3, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		/* 
		 * Middle blocks processing, no padding required here 
		 */
		*(unsigned int *)ecbio = *(unsigned int *)&out[i - 8] ^ 
					*(unsigned int *)&buf[i];
		*(unsigned int *)(ecbio + 4) = *(unsigned int *)&out[i - 4] ^ 
					*(unsigned int *)&buf[i + 4];
		endes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)(ecbio + 4);
	}

	/*
	 * Set the iv to be the last
	 * encrypted block;
	 */
	BCOPY((caddr_t)&out[i], (caddr_t)iv, 8);
	return;
}

STATIC
void
dedes_ede_cbc_v1(void *cs, char *in, u_int *lenp, char *out, char *iv, 
			u_int ivlen, u_char *payload)
{
	char ecbio[8];
	int i, mod8, padlen;
	unsigned long *ks1, *ks2, *ks3;

	int len = *lenp;
	if (len == 0)
		return;
	ks1 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched1;
	ks2 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched2;
	ks3 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched3;

	mod8 = (len & 0x07);	/* technically this is (len % 8) */
	if (mod8 != 0)	{  /* CBC decryption always expects block-size multiple */
		*lenp = 0;
		return;
	}
					
	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = 	*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[4];
	dedes_ede_ecb(ks1, ks2, ks3, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)iv ^ 
					*(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(iv + 4) ^ 
					*(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		*(unsigned int *)ecbio = 	*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[i+4];
		dedes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)&in[i - 8] ^ 
					*(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)&in[i - 4] ^ 
					*(unsigned int *)(ecbio + 4);
	}
	
	if (! ((struct des_ede_cbc_state *)cs)->pad) {
		*lenp=len;
		return;
	}

	if ((padlen = (int)((unsigned char)(out[i-1]))) > 0x08) {
		printf("dedes_ede_cbc: error in pad block, pad > 08\n");
		*lenp = 0;
		return;
	}

	/*
	 * Adjust the length of the output
	 * for padding. The last byte of the
	 * output will always indicate the
	 * length of the pad.
	 */
	*lenp = len - padlen;
	return;
}

STATIC
void
dedes_ede_cbc(void *cs, char *in, u_int *lenp, char *out, char *iv, 
			u_int ivlen, u_char *payload)
{
	char ecbio[8];
	int i, mod8, padlen;
	unsigned long *ks1, *ks2, *ks3;

	int len = *lenp;
	if (len == 0)
		return;
	ks1 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched1;
	ks2 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched2;
	ks3 = (unsigned long *)((struct des_ede_cbc_state *)cs)->keysched3;

	mod8 = (len & 0x07);	/* technically this is (len % 8) */
	if (mod8 != 0)	{ /* CBC decryption always expects block-size multiple */
		*lenp = 0;
		return;
	}
					
	/* 
	 * First block processing 
	 */

	*(unsigned int *)ecbio = 	*(unsigned int *)&in[0];
	*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[4];
	dedes_ede_ecb(ks1, ks2, ks3, ecbio);
	*(unsigned int *)&out[0] = *(unsigned int *)iv ^ 
					*(unsigned int *)ecbio;
	*(unsigned int *)&out[4] = *(unsigned int *)(iv + 4) ^ 
					*(unsigned int *)(ecbio + 4);

	for (i = 8; i < len ; i += 8) {
		*(unsigned int *)ecbio = 	*(unsigned int *)&in[i];
		*(unsigned int *)(ecbio + 4) =  *(unsigned int *)&in[i+4];
		dedes_ede_ecb(ks1, ks2, ks3, ecbio);
		*(unsigned int *)&out[i] = *(unsigned int *)&in[i - 8] ^ 
					*(unsigned int *)ecbio;
		*(unsigned int *)&out[i + 4] = *(unsigned int *)&in[i - 4] ^ 
					*(unsigned int *)(ecbio + 4);
	}
	
	if ((padlen = (int)((unsigned char)(out[len-2]))) > 0x08) {
		printf("dedes_ede_cbc: error in pad block, pad > 08\n");
		*lenp = 0;
		return;
	}

	/*
	 * Adjust the length of the output
	 * for padding. The last byte of the
	 * output will always indicate the
	 * length of the pad.
	 */
	*payload = out[len - 1];
	*lenp = len - padlen - 2;
	return;
}

STATIC
void
des_ede_cbc_k2_close(void *cs)
{
	BZERO(cs, sizeof(struct des_ede_cbc_state));
	SYSMEM_FREE( cs, sizeof(struct des_ede_cbc_state));
	des_ede_k2_busy--;
	return;
}


STATIC
void
des_ede_cbc_k3_close(void *cs)
{
	BZERO(cs, sizeof(struct des_ede_cbc_state));
	SYSMEM_FREE( cs, sizeof(struct des_ede_cbc_state));
	des_ede_k3_busy--;
	return;
}
