/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_md5.c	1.11 96/10/08 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_crypt.h>
#include <skip_key.h>
#include <skip_ah.h>
#include <skip_ioctl.h>

/*
 * SKIP MD5 AH module
 */
#include "md5.h"

/*
 * Local functions prototypes
 */
static int 
skip_sign_md5(skip_keycb_t *,
		unsigned char *, unsigned char *, unsigned int);

/*
 * MD5 MAC module descriptor
 */
skip_mac_t 		skip_md5_mod = {
				SKIP_MAC_MD5,	/* MAC module ID	*/
				16,		/* Key length 		*/
				16,		/* Mac data length	*/
				skip_sign_md5,	/* MAC routine		*/
				0,		/* statistics...	*/
				0,
				0,
				0
};

#define MD5_AKP_PAD_LEN		64
#define MD5_AKP_PAD_CHAR	0x80

/*
 * skip_sign_md5()
 *
 * MD5 MAC alg routine
 */
static int 
skip_sign_md5(skip_keycb_t *cp,
		unsigned char *p_ip, unsigned char *p_ah, unsigned int len)
{
	struct xMD5Context	ctx;
	unsigned char		Akp_pad[MD5_AKP_PAD_LEN];
	unsigned int		nbits, fillen;

	/*
	 * Initialize the MD5 context..
	 */
	xMD5Init(&ctx);

	/*
	 * We have first to prepend AKp to MD
	 */
	xMD5Update(&ctx, (unsigned char *)cp->A_kp.buf, cp->A_kp.len);
	if (cp->A_kp.len < MD5_AKP_PAD_LEN) {
		/*
		 * We need to pad...
		 */
		fillen =  MD5_AKP_PAD_LEN - cp->A_kp.len - 8;
		nbits = cp->A_kp.len * 8;

		BZERO(Akp_pad, MD5_AKP_PAD_LEN);
		Akp_pad[0] = MD5_AKP_PAD_CHAR;
		xMD5Update(&ctx, Akp_pad, fillen);

		BZERO(Akp_pad, 8);
		Akp_pad[0] = (unsigned char) (nbits & 0xff);
		Akp_pad[1] = (unsigned char) ((nbits >> 8) & 0xff);
		Akp_pad[2] = (unsigned char) ((nbits >> 16) & 0xff);
		Akp_pad[3] = (unsigned char) ((nbits >> 24) & 0xff);
		xMD5Update(&ctx, Akp_pad, 8);
	}

	/*
	 * Now, process the SKIP packet
	 */
	xMD5Update(&ctx, p_ip, len);

	/*
	 * Last, we append the A_kp...
	 */
	xMD5Update(&ctx, (unsigned char *)cp->A_kp.buf, cp->A_kp.len);

	/*
	 * Now, get back the MD5 message digest...
	 */
	xMD5Final(p_ah, &ctx);

	return(0);
}
