/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_wrapper.c	1.13 96/01/26 Sun Microsystems"
 
/* 
 * System includes 
 */ 
#include <skip_os.h> 
/*
#ifdef OPENPROMS
#include <sun/openprom.h>
#endif
*/
 
/* 
 * SKIP includes 
 */ 
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_es.h>
#include <skip_if.h>


/*
 * SunOS 4.1.x loadable driver wrapper for the SKIP module
 */
extern char		skip_module_name[];

/*
 * Module linkage information for the kernel.
 */
extern int		nulldev();

struct cfdriver skipcd=
        { NULL, "skip", NULL, NULL, DV_DULL, 0 };

struct cdevsw skipdevsw = {
        skip_ifopen, skip_ifclose, skip_ifread, skip_ifwrite, skip_ifioctl,
	NULL, NULL, NULL, skip_ifselect, NULL, NULL 
};

MOD_DEV("skipmod", LM_DT_CHAR, -1, (void *)&skipdevsw)

extern int		skip_init(), skip_uninit();

/*ARGSUSED*/
int
skipmod_load(struct lkm_table *lkmtp, int cmd)
{

	int rc;
	rc = skip_init();
	if (rc != 0) {
		return (rc);
	}
	uprintf("skip: driver loaded\n");
	return (0);
}

skipmod_unload(struct lkm_table *lkmtp, int cmd)
{
	
	int rc;
	rc = skip_uninit();
	if (rc == 0) {
		uprintf("skip: driver unloaded\n");
	}
	return (rc);
}

xxxinit(struct lkm_table *lkmtp, int cmd, int ver)
{
	DISPATCH(lkmtp, cmd, ver, skipmod_load, skipmod_unload, nosys);
}
