/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_key.h	1.29 96/07/08 Sun Microsystems"

#ifndef SKIP_KEY_H
#define SKIP_KEY_H

#ifdef  __cplusplus
extern "C" {
#endif

/* 
 * max number of bytes to encrypt before changing key
 */ 
#define	SKIP_KEY_MAX_BYTES      512*1024

/* 
 * timer granularity (seconds)
 */ 
#define	SKIP_KEY_TICK           1 

/* 
 * max number of packets to hold while waiting for a key
 */ 
#define	SKIP_KEY_MAX_PKTS	20

/*
 * max time to wait for a response from the key manager (seconds)
 */
#define	SKIP_KEY_MAX_KM_WAIT	10

/*
 * delete an unused key after this time (seconds)
 */
#define	SKIP_KEY_MAX_IDLE	30

/*
 * XXX
 */
#define SKIP_KEY_MAX_USE	30

/*
 * maximum number of cipher states to have open at one time
 */
#define	SKIP_KEY_MAX_ENTRIES	512

/*
 * size of SKIP hash table size.  Don't change this without also
 * modifying the hashing functions SKIP_ENCRYPT_HASH()/SKIP_DECRYPT_HASH()
 */
#define	SKIP_HASH_TABLESZ	64
#define	SKIP_ENCRYPT_HASH(x)	(((unsigned char *)(x))[3] & 0x3f)
#define	SKIP_DECRYPT_HASH(x)	(((unsigned char *)(x))[3] & 0x3f)
#define	SKIP_IGNORE_VAL		(-1)

#define	SKIP_MAC_ON	0x02	/* MAC mode was used	*/
#define	SKIP_CRYPT_ON	0x04	/* Crypt mode was used	*/
/*
 * Structure describing a encrypt/decrypt packet result
 */
typedef struct {
	unsigned int	rc;	/* returned code		*/
	unsigned int	offset;	/* Clear data offset		*/
	unsigned char	modes;	/* MAC and CRYPT modes ...	*/
	unsigned char	proto;	/* IP protocol 			*/
	boolean_t	sync;	/* True if proceed synchronously*/
	skip_param_t	params;	/* SKIP parameters		*/
} skip_arg_t;

/*
 * structure describing a SKIP client
 */
typedef struct {
	void			*client_data;
	void			(*encrypt_done)(
					void *,
					SKIP_BUF_T *,
					SKIP_BUF_T *,
					void *,
					skip_arg_t *
					);
	void			(*decrypt_done)(
					void *,
					SKIP_BUF_T *,
					SKIP_BUF_T *,
					void *,
					skip_arg_t *
					);
} skip_client_t;

/*
 * structure describing skip header information
 */
#define	SKIP_INIT_HDR_LG	84

typedef struct {
	skip_param_t		params;
	skip_key_var_t		ekp;
	skip_key_var_t		mid;
	/*
	 * preinitialised packet header
	 */
	unsigned char		info[SKIP_INIT_HDR_LG];
	unsigned short		hdrlen;
} skip_hdr_t;

#define HDRCOPY(from, to)	BCOPY((caddr_t) from, (caddr_t) to, \
							 sizeof(skip_hdr_t))
/*
 * structure describing queued callback information
 */
typedef struct skip_queue {
	struct skip_queue	*next;
	SKIP_BUF_T		*in;		/* input pkt		*/
	SKIP_BUF_T		*out;		/* output pkt		*/
	skip_client_t		*client;	/* callback client	*/
	void			*arg;		/* argument		*/
	struct sockaddr		dst;		/* XXX 4.x only		*/
	skip_arg_t		res;		/* crypt/decrypt result	*/
} skip_queue_t;

/*
 * structure describing a key control block
 */
typedef struct skip_key {
	struct skip_key		*next;
	struct skip_key		*prev;
	void			*cs;			/* channel state */
	skip_hdr_t		hdr;			/* skip header info */
	int			ttl;			/* time to live */
	unsigned int		obytes;			/* bytes xmited */
	unsigned int		last_obytes;		/* last bytes xmited */
	int			max_obytes;		/* max bytes allowed */
	unsigned int		hash;			/* hash location */
	skip_queue_t		*queue;			/* queue of callbacks */
	int			data_offset;		/* Payload offset */
	skip_key_var_t		E_kp;			/* ESP derived E_kp */
	skip_key_var_t		A_kp;			/* AH derived A_kp */
	boolean_t		init;			/* CB status */
} skip_keycb_t;


/*
 * Structure describing a Master Local Key ID linked list
 */
typedef struct skip_keyid {
	struct skip_keyid	*next;		/* Next Key ID in list	*/
	skip_key_var_t		mkeyid;		/* Master Key ID	*/
} skip_keyid_t;
	
/*
 * Get the crypto module ID from SKIP version and Kp alg
 */
#define GETCRYPTMOD(version, kp) \
	(version == SKIP_V1 ? &skip_cryptors_v1[kp] : &skip_cryptors[kp])

/*
 * shared exported functions
 */
#ifndef  __cplusplus
void		*skip_open( void *,
			void (*encrypt_done)(
				void *, SKIP_BUF_T *, SKIP_BUF_T *,
				void *, skip_arg_t *),
			void (*decrypt_done)(
				void *, SKIP_BUF_T *, SKIP_BUF_T *,
				void *, skip_arg_t *)
		);
#endif
void		skip_close();
int		skip_encrypt(void *, SKIP_BUF_T *, SKIP_BUF_T *,
			skip_param_t *, void *);
int		skip_decrypt(void *, SKIP_BUF_T *, SKIP_BUF_T *,
			skip_hdr_t *hdr, int, void *);
int		skip_key_check(skip_keycb_t *, void *);
void		skip_key_iterate(int (*)(), void *);
int		skip_hdr_encode(skip_hdr_t *, unsigned char *);
int		skip_iv_encode(skip_hdr_t *, unsigned char *);
void		skip_hdr_init(skip_keycb_t *);

void		skip_key_tellkm(enum skip_msgs, skip_keycb_t *);
void		skip_key_fromkm(union skip_messages *, unsigned int);
void		skip_update_encrypt_key(struct Encrypted_key_rsp *);
void		skip_update_decrypt_key(struct Decrypted_key_rsp *);

void		skip_local_keyid_init();
void		skip_local_keyid_uninit();
void		skip_set_local_keyid(unsigned char , skip_key_var_t *);
int		skip_check_keyid(unsigned char , skip_key_var_t *, boolean_t);
int		skip_get_default_keyid(unsigned char, unsigned char *);


/*
 * exported functions for SunScreen Mode 
 */
int		skip_hdr_v1_decode(unsigned char *,
				unsigned char *, skip_hdr_t *);
int		skip_iv_v1_decode(skip_hdr_t *, unsigned char *,
							unsigned char *);

/*
 * exported functions for IPSP mode
 */
int		skip_hdr_ipsp_decode(unsigned char *,
				unsigned char *, skip_hdr_t *);
int		skip_iv_esp_decode(skip_hdr_t *, unsigned char *,
							unsigned char *);


#if defined(_KERNEL) || defined(KERNEL)
/*
 * function prototypes
 */
void		skip_key_fromkm(union skip_messages *, unsigned int);
#endif


/*
 * external variables
 */
extern unsigned char	skip_nsid[];
extern int		skip_key_max_bytes;
extern int		skip_key_max_pkts;
extern int		skip_key_max_km_wait;
extern int		skip_key_max_idle;
extern int		skip_key_max_use;
extern const int	skip_key_tick;
extern int		skip_key_debug;
/*
 * Supported Kij algorithms by the key manager
 */
extern boolean_t	skip_kmgr_kij_alg[];
extern boolean_t	skip_kmgr_kij_alg_v1[];

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_KEY_H */
