/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
#pragma ident	"@(#)skip_localidlist.C	1.11 96/10/11"

#include <skip_os.h>

#include "skip_conf.h"
#include "skip_log.h"

#include "my_types.h"
#include "Bstream.h"
#include "Bigint.h"
#include "SkipCert.h"
#include "HashCert.h"
#include "X509skip.h"
#include "LL.h"
#include "skipd.h"
#include "skip_keymgr.h"
#include "skip_params.h"
#include "skip_cache.h"
#include "skip_certbase.h"
#include "skip_secret.h"
#include "skip_localid.h"
#include "skip_localidlist.h"
#include "skip_softlocalid.h"

LocalId*
LocalId_list::first()
{
	LocalId **ret;
	ret = ids.first();
	if (ret)
		return *ret;
	else
		return NULL;

}
 
LocalId*
LocalId_list::next()
{
	LocalId **ret;
	ret = ids.next();
	if (ret)
		return *ret;
	else
		return NULL;
}
 
//  is_local_identity(nsid, mkid)
//
//  Is the indicated (nsid,mkid) one of our local slots?

int
LocalId_list::is_local_identity(u_char nsid, Bstream &keyid)
{
	LocalId *local;

	if (!nsid)
		nsid = 1;
	
        for (local = first(); local != NULL; local=next())
		if (local->nsid == nsid && local->mkeyid == keyid)
			return TRUE;

	return FALSE;
}
 
LocalId *
LocalId_list::find_valid(u_char nsid, Bstream &keyid, const int now)
{
	LocalId *local;
	int ret;

	if (!nsid)
		nsid = 1;
	
        for (local = first(); local != NULL; local=next()) {
		if (local->nsid == nsid && local->mkeyid == keyid) {
                        ret = local->CheckValid(now);
                        if (ret == 0) {          // Valid
                                return local;
                        } else if (ret < 0)     { // Expired
                                ids.delete_current();
                                skip_log(SKIP_NOTICE,
		       "Local secret nsid=%d mkid=%s has expired. Deleting.",
					local->nsid,
					local->mkeyid.get_info_str());
                        }
 
                }
        }
	return NULL;
}

void LocalId_list::add_soft_localid(SlotParse* s)
{

	LocalId *l;
	l = new SoftLocalId(s->nsid, s->mkid, s->g, s->p,
			s->cert->skip_notvalidbefore(), 
			s->cert->skip_notvalidafter(),
			s->secret,
			s->cert->skip_pubkey());

	if (l->mkeyid.getlength() == 0) {	// invalid slot, don't add
		delete l;
		return;
	}

	ids.insert(l);

	if (skip_conf.enable_certd) {
		CertInfo ci;

		ci.nsid = s->nsid;
		ci.mkid = s->cert->skip_name();
		ci.cert = s->cert;	// don't let ci destructor free this
					// see below

		if (db_put_certinfo(ci)) {
			skip_log(SKIP_ERROR, "couldn't store local "
				"certificate nsid=%d mkid=%s in database",
					s->nsid, s->mkid.get_info_str());
		}

		ci.cert = NULL;		// don't let ci destructor free this
	}
}

int LocalId_list::load(char *path)
{
	DIR *d;
	struct dirent *e;
	char buf[256];

//  Read rc files from the /etc/skip/localid directory

	d = opendir(path);
	if (d == NULL)
		return FALSE;

	while (e = readdir(d)) {
		int len = strlen(e->d_name);
		if (len < 4 || strcmp(e->d_name + len - 3, ".rc") != 0)
			continue;

		SlotParse s;

		sprintf(buf, "%s/%s", path, e->d_name);
		if (!s.load(buf))
			continue;

		switch (s.type) {
		case SLOT_SOFT:
			add_soft_localid(&s);
			break;

		case SLOT_CARD:
		case SLOT_MANUAL:
		default:
			skip_log(SKIP_ERROR, "%s: unknown slot type",
						e->d_name);
		}
	}

	closedir(d);

	return TRUE;
}
