/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)es_glue.h	1.13 96/10/08 Sun Microsystems"


#ifdef  __cplusplus
extern "C" {
#endif

/*
 * textual strings used
 */
#define	STRSZ				(256)
#define	SKIP_DEFKEY			"default local key"
#define	SKIP_NAMEHOST			"Host"
#define	SKIP_NAMENET			"Network"
#define	SKIP_CONFIRM			"Confirm"
#define	SKIP_CANCEL			"Cancel further messages"
#define	SKIP_ACCESS			"Allow Access"
#define	SKIP_NO_ACCESS			"No Access"
#define	SKIP_UNKNOWN			"unknown"
#define	SKIP_TUNNEL_1			"skip : an entry is needed for the tunnel host %s (%s)"
#define	SKIP_TUNNEL_2			"Suggested parameters for %s:"
#define	SKIP_TUNNEL_3			"Add tunnel host"
#define	SKIP_TUNNEL_4			"Cancel"

/*
 * error messages
 */
#define	SKIP_BAD_THING			"Bad %s \"%s\""
#define	SKIP_MISSING_KEYID		"You must specify a Remote Key ID"
#define	SKIP_BADKEYGET			"Cannot retrieve list of local keys"
#define	SKIP_BADLOCALKEY		"Local key %d for NSID #%d is bad"
#define	SKIP_BADREMOTEKEY		"Remote key for NSID #%d is bad"
#define	SKIP_BAD_NSID			"Bad name space identifier \"%s\""
#define	SKIP_BADNEWWIN			"Cannot create new window"
#define	SKIP_BAD_NETMASK		"Bad netmask \"%s\""
#define	SKIP_V0_NOMADIC			"Can't have a nomadic cleartext host"
#define	SKIP_RAW_NOMADIC		"Can't have a nomadic manually keyed host"

/*
 * helper commands
 */
#define	KEYSTAT				"keystat"
#define	SKIPSTAT_CMD			"skipstat"
#define	SKIPHOST_CMD			"skiphost"
#define	SKIPSTAT_UI			"skipstat_ui"

/*
 * icons
 */
#define	SKIP_SMALL_ICON			"skiptool_small.ras"
#define	SKIP_UNKNOWN_ICON		"unknown.ras"
#define	SKIP_NONE_ICON			"none.ras"
#define	SKIP_ICON_V1			"icon_v1.ras"
#define	SKIP_ICON_V2			"icon_v2.ras"
#define	SKIP_ICON_NOMADIC		"nomadic.ras"
#define	SKIP_MSG_WAIT			4


enum { hostwin, netwin, nomwin };
enum { NoAccess, AskFirst, AddAutomatically };
enum { Select = 0, Deselect, DblClick };

#define	SKIP_DEFMASK			"255.255.255.0"

/*
 * structure grouping abstract window information & ACL params
 */
typedef struct {
	/*
	 * xview objects
	 */
	Xv_opaque			win;
	Xv_opaque			addr;
	Xv_opaque			mask;
	Xv_opaque			r_nsid;
	Xv_opaque			keyid;
	Xv_opaque			s_nsid;
	Xv_opaque			local_keyid;
	Xv_opaque			kij_alg;
	Xv_opaque			kp_alg;
	Xv_opaque			mac_alg;
	Xv_opaque			skip_mode;
	Xv_opaque			tunnel_addr;
	Xv_opaque			tunnel_label;
	union wins {
		skiptool_hostwin_objects	*hostwin;
		skiptool_hostwin_v1_objects	*hostwin_v1;
		skiptool_hostwin_v2_objects	*hostwin_v2;
		skiptool_hostwin_raw_objects	*hostwin_raw;
		skiptool_netwin_objects		*netwin;
		skiptool_netwin_v1_objects	*netwin_v1;
		skiptool_netwin_v2_objects	*netwin_v2;
		skiptool_netwin_raw_objects	*netwin_raw;
		skiptool_nomwin_v1_objects	*nomwin_v1;
		skiptool_nomwin_v2_objects	*nomwin_v2;
		void				*win;
	} w;
	Xv_opaque			list;	/* owner scrolling list */
	skip_param_t			params;	/* access control parameters */
	boolean_t			is_add_win;
} es_acl_t;

#define	ALLOC_CHECK(w)	if (!w) { \
				alert(XV_NULL, SKIP_BADNEWWIN, B_TRUE); \
                                return (B_FALSE); \
			}
 
#define	SET_ICON(i, v, n)	(void) \
			xv_set(i, PANEL_LABEL_IMAGE, glyph_of(v, n), NULL); 
#define	WIN(a, w)	(a)->win = (w)
#define	ADDR(a, w)	(a)->addr = (w)
#define	MASK(a, w)	(a)->mask = (w)
#define	R_NSID(a, w)	(a)->r_nsid = (w)
#define	R_MKEYID(a, w)	(a)->keyid = (w)
#define	S_NSID(a, w)	(a)->s_nsid = (w)
#define	S_MKEYID(a, w)	(a)->local_keyid = (w)
#define	KIJ_ALG(a, w)	(a)->kij_alg = (w)
#define	KP_ALG(a, w)	(a)->kp_alg = (w)
#define	MAC_ALG(a, w)	(a)->mac_alg = (w)
#define	SKIP_MODE(a, w)	(a)->skip_mode = (w)
#define	TUNNEL_ADDR(a, w)	(a)->tunnel_addr = (w)
#define	TUNNEL_LABEL(a, w)	(a)->tunnel_label = (w)

extern char				ifname[];
extern char				*es_path(char *);
extern void				alert(Panel_item, char *, int);
extern void				acl_build();
extern int				enable_checks();
extern int				required_systems_build();
extern void				show_mode();
extern void				es_check_tunnel(es_acl_t *);

extern skiptool_base_window_objects	*Skiptool_base_window;
skiptool_key_params_win_objects		*Skiptool_key_params_win;
skiptool_required_win_objects		*Skiptool_required_win;
skiptool_about_win_objects		*Skiptool_about_win;
skiptool_base_window_objects		*Skiptool_base_window;
skiptool_key_params_win_objects		*Skiptool_key_params_win;
skiptool_required_win_objects		*Skiptool_required_win;
skiptool_about_win_objects		*Skiptool_about_win;
skiptool_hostwin_objects		*Skiptool_hostwin;
skiptool_hostwin_v1_objects		*Skiptool_hostwin_v1;
skiptool_hostwin_v2_objects		*Skiptool_hostwin_v2;
skiptool_hostwin_raw_objects		*Skiptool_hostwin_raw;
skiptool_netwin_objects			*Skiptool_netwin;
skiptool_netwin_v1_objects		*Skiptool_netwin_v1;
skiptool_netwin_v2_objects		*Skiptool_netwin_v2;
skiptool_netwin_raw_objects		*Skiptool_netwin_raw;
skiptool_nomwin_v1_objects		*Skiptool_nomwin_v1;
skiptool_nomwin_v2_objects		*Skiptool_nomwin_v2;
