/*----------------------------------------------------------------------------+
 |                                                                            |
 |   Package: krypto                                                          |
 |   Author: Eugene Jhong                                                     |
 |                                                                            |
 +----------------------------------------------------------------------------*/

#if     !defined(_PROTO)
#ifdef  __STDC__
#define _PROTO(x)    x
#define t_const const
#else
#define _PROTO(x)    ()
#define t_const
#endif
#endif

#include "krypto_locl.h"

struct md5Context {
	uint32 buf[4];
	uint32 bits[2];
	unsigned char in[64];
};

void t_md5Init _PROTO((struct md5Context *context));
void t_md5Update _PROTO((struct md5Context *context, unsigned char const *buf,
		    unsigned len));
void t_md5Final _PROTO((unsigned char digest[16], struct md5Context *context));
void t_md5Transform _PROTO((uint32 buf[4], uint32 const in[16]));

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 */
typedef struct md5Context md5_CTX;
