#ifndef GABA_DEFINE
struct tcpip_channel
{
  struct ssh_channel super;
  struct io_fd *socket;
};
extern struct lsh_class tcpip_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_channel *i = (struct tcpip_channel *) o;
  mark((struct lsh_object *) i->socket);
}

struct lsh_class tcpip_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "tcpip_channel", sizeof(struct tcpip_channel),
  do_tcpip_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct direct_tcp_server_start_io
{
  struct command super;
  UINT32 block_size;
  struct channel_open_callback *response;
  struct tcpip_channel *channel;
};
extern struct lsh_class direct_tcp_server_start_io_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_direct_tcp_server_start_io_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct direct_tcp_server_start_io *i = (struct direct_tcp_server_start_io *) o;
  mark((struct lsh_object *) i->response);
  mark((struct lsh_object *) i->channel);
}

struct lsh_class direct_tcp_server_start_io_class =
{ STATIC_HEADER,
  &command_class, "direct_tcp_server_start_io", sizeof(struct direct_tcp_server_start_io),
  do_direct_tcp_server_start_io_mark,
  NULL
};
#endif /* !GABA_DECLARE */

static struct lsh_object *
make_direct_tcp_connect(struct command *connect, struct command *start_io)
{
  /* (B start_io connect) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return
    B2(((struct lsh_object *) start_io), ((struct lsh_object *) connect));
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
#ifndef GABA_DEFINE
struct open_direct_tcpip
{
  struct channel_open super;
  struct io_backend *backend;
};
extern struct lsh_class open_direct_tcpip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_open_direct_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_direct_tcpip *i = (struct open_direct_tcpip *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class open_direct_tcpip_class =
{ STATIC_HEADER,
  &channel_open_class, "open_direct_tcpip", sizeof(struct open_direct_tcpip),
  do_open_direct_tcpip_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct open_tcpip_command
{
  struct channel_open_command super;
  struct address_info *local;
  struct listen_value *peer;
};
extern struct lsh_class open_tcpip_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_open_tcpip_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_tcpip_command *i = (struct open_tcpip_command *) o;
  mark((struct lsh_object *) i->local);
  mark((struct lsh_object *) i->peer);
}

struct lsh_class open_tcpip_command_class =
{ STATIC_HEADER,
  &channel_open_command_class, "open_tcpip_command", sizeof(struct open_tcpip_command),
  do_open_tcpip_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

static struct lsh_object *
make_forward_listen(struct io_backend *backend, struct ssh_connection *connection)
{
  /* (S (C (B* listen (B start_io) (C* C open_forwarded_tcp connection)) backend) I) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return
    S2(C2(Bp3(LISTEN_COMMAND, B1(FORWARD_START_IO), Cp3(C, OPEN_FORWARDED_TCP, ((struct lsh_object *) connection))), ((struct lsh_object *) backend)), I);
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
#ifndef GABA_DEFINE
struct tcp_forward_continuation
{
  struct command_continuation super;
  struct ssh_connection *connection;
  struct forwarded_port *forward;
  struct global_request_callback *c;
};
extern struct lsh_class tcp_forward_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcp_forward_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcp_forward_continuation *i = (struct tcp_forward_continuation *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->forward);
  mark((struct lsh_object *) i->c);
}

struct lsh_class tcp_forward_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "tcp_forward_continuation", sizeof(struct tcp_forward_continuation),
  do_tcp_forward_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct tcpip_forward_request
{
  struct global_request super;
  struct io_backend *backend;
};
extern struct lsh_class tcpip_forward_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_forward_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_forward_request *i = (struct tcpip_forward_request *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class tcpip_forward_request_class =
{ STATIC_HEADER,
  &global_request_class, "tcpip_forward_request", sizeof(struct tcpip_forward_request),
  do_tcpip_forward_request_mark,
  NULL
};
#endif /* !GABA_DECLARE */

