#ifndef GABA_DEFINE
struct userauth_packet_handler
{
  struct packet_handler super;
  struct client_userauth *userauth;
};
extern struct lsh_class userauth_packet_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_userauth_packet_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct userauth_packet_handler *i = (struct userauth_packet_handler *) o;
  mark((struct lsh_object *) i->userauth);
}

struct lsh_class userauth_packet_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "userauth_packet_handler", sizeof(struct userauth_packet_handler),
  do_userauth_packet_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_userauth_method
{
  struct lsh_object super;
  int (*(setup))(struct client_userauth_method *self, struct client_userauth *userauth, struct ssh_connection *connection);
  void (*(send))(struct client_userauth_method *self, struct client_userauth *userauth, struct ssh_connection *connection);
  void (*(cleanup))(struct client_userauth_method *self, struct client_userauth *userauth, struct ssh_connection *connection);
};
extern struct lsh_class client_userauth_method_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class client_userauth_method_class =
{ STATIC_HEADER,
  0, "client_userauth_method", sizeof(struct client_userauth_method),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_publickey_method
{
  struct client_userauth_method super;
  UINT32 current_key;
  struct object_list *keys;
};
extern struct lsh_class client_publickey_method_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_publickey_method_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_publickey_method *i = (struct client_publickey_method *) o;
  mark((struct lsh_object *) i->keys);
}

struct lsh_class client_publickey_method_class =
{ STATIC_HEADER,
  &client_userauth_method_class, "client_publickey_method", sizeof(struct client_publickey_method),
  do_client_publickey_method_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_userauth
{
  struct command super;
  struct lsh_string *username;
  int service_name;
  int current_method;
  struct alist *methods;
};
extern struct lsh_class client_userauth_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_userauth_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_userauth *i = (struct client_userauth *) o;
  mark((struct lsh_object *) i->methods);
}

static void do_client_userauth_free(struct lsh_object *o)
{
  struct client_userauth *i = (struct client_userauth *) o;
  lsh_string_free(i->username);
}

struct lsh_class client_userauth_class =
{ STATIC_HEADER,
  &command_class, "client_userauth", sizeof(struct client_userauth),
  do_client_userauth_mark,
  do_client_userauth_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct success_handler
{
  struct userauth_packet_handler super;
  struct command_continuation *c;
};
extern struct lsh_class success_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_success_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct success_handler *i = (struct success_handler *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class success_handler_class =
{ STATIC_HEADER,
  &userauth_packet_handler_class, "success_handler", sizeof(struct success_handler),
  do_success_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct failure_handler
{
  struct userauth_packet_handler super;
  struct exception_handler *e;
};
extern struct lsh_class failure_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_failure_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct failure_handler *i = (struct failure_handler *) o;
  mark((struct lsh_object *) i->e);
}

struct lsh_class failure_handler_class =
{ STATIC_HEADER,
  &userauth_packet_handler_class, "failure_handler", sizeof(struct failure_handler),
  do_failure_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

