#ifndef GABA_DEFINE
struct authorization_db
{
  struct lookup_verifier super;
  struct signature_algorithm *signalgo;
  struct hash_algorithm *hashalgo;
};
extern struct lsh_class authorization_db_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_authorization_db_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct authorization_db *i = (struct authorization_db *) o;
  mark((struct lsh_object *) i->signalgo);
  mark((struct lsh_object *) i->hashalgo);
}

struct lsh_class authorization_db_class =
{ STATIC_HEADER,
  &lookup_verifier_class, "authorization_db", sizeof(struct authorization_db),
  do_authorization_db_mark,
  NULL
};
#endif /* !GABA_DECLARE */

