#ifndef CLASS_DEFINE
struct server_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  struct signer *secret;
  struct lsh_string *host_key;
  UINT32 block_size;
  const char * id_comment;
  struct ssh1_fallback *fallback;
  struct randomness *random;
  struct make_kexinit *init;
  struct packet_handler *kexinit_handler;
};
extern struct lsh_class server_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_callback *i = (struct server_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->secret);
  mark((struct lsh_object *) i->fallback);
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->kexinit_handler);
}

static void do_server_callback_free(struct lsh_object *o)
{
  struct server_callback *i = (struct server_callback *) o;
  lsh_string_free(i->host_key);
}

struct lsh_class server_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "server_callback", sizeof(struct server_callback),
  do_server_callback_mark,
  do_server_callback_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_line_handler
{
  struct line_handler super;
  struct ssh_connection *connection;
  int fd;
  struct ssh1_fallback *fallback;
};
extern struct lsh_class server_line_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_line_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_line_handler *i = (struct server_line_handler *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->fallback);
}

struct lsh_class server_line_handler_class =
{ STATIC_HEADER,
  &line_handler_class, "server_line_handler", sizeof(struct server_line_handler),
  do_server_line_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_cleanup
{
  struct close_callback super;
  struct ssh_connection *connection;
};
extern struct lsh_class server_cleanup_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_cleanup_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_cleanup *i = (struct server_cleanup *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class server_cleanup_class =
{ STATIC_HEADER,
  &close_callback_class, "server_cleanup", sizeof(struct server_cleanup),
  do_server_cleanup_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct process_resource
{
  struct resource super;
  pid_t pid;
  int signal;
};
extern struct lsh_class process_resource_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class process_resource_class =
{ STATIC_HEADER,
  &resource_class, "process_resource", sizeof(struct process_resource),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_session
{
  struct ssh_channel super;
  struct unix_user *user;
  struct resource *process;
  struct pty_info *pty;
  struct lsh_string *term;
  struct io_fd *in;
  struct io_fd *out;
  struct io_fd *err;
};
extern struct lsh_class server_session_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_session *i = (struct server_session *) o;
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->process);
  mark((struct lsh_object *) i->pty);
  mark((struct lsh_object *) i->in);
  mark((struct lsh_object *) i->out);
  mark((struct lsh_object *) i->err);
}

static void do_server_session_free(struct lsh_object *o)
{
  struct server_session *i = (struct server_session *) o;
  lsh_string_free(i->term);
}

struct lsh_class server_session_class =
{ STATIC_HEADER,
  &ssh_channel_class, "server_session", sizeof(struct server_session),
  do_server_session_mark,
  do_server_session_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct open_session
{
  struct channel_open super;
  struct unix_user *user;
  struct alist *session_requests;
};
extern struct lsh_class open_session_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_open_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_session *i = (struct open_session *) o;
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->session_requests);
}

struct lsh_class open_session_class =
{ STATIC_HEADER,
  &channel_open_class, "open_session", sizeof(struct open_session),
  do_open_session_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_connection_service
{
  struct unix_service super;
  struct alist *global_requests;
  struct alist *session_requests;
  struct io_backend *backend;
};
extern struct lsh_class server_connection_service_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_connection_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_connection_service *i = (struct server_connection_service *) o;
  mark((struct lsh_object *) i->global_requests);
  mark((struct lsh_object *) i->session_requests);
  mark((struct lsh_object *) i->backend);
}

struct lsh_class server_connection_service_class =
{ STATIC_HEADER,
  &unix_service_class, "server_connection_service", sizeof(struct server_connection_service),
  do_server_connection_service_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct exit_shell
{
  struct exit_callback super;
  struct server_session *session;
};
extern struct lsh_class exit_shell_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_exit_shell_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct exit_shell *i = (struct exit_shell *) o;
  mark((struct lsh_object *) i->session);
}

struct lsh_class exit_shell_class =
{ STATIC_HEADER,
  &exit_callback_class, "exit_shell", sizeof(struct exit_shell),
  do_exit_shell_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct shell_request
{
  struct channel_request super;
  struct io_backend *backend;
  struct reap *reap;
};
extern struct lsh_class shell_request_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_shell_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct shell_request *i = (struct shell_request *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->reap);
}

struct lsh_class shell_request_class =
{ STATIC_HEADER,
  &channel_request_class, "shell_request", sizeof(struct shell_request),
  do_shell_request_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

