#ifndef CLASS_DEFINE
struct tcpip_channel
{
  struct ssh_channel super;
  struct io_fd *socket;
};
extern struct lsh_class tcpip_channel_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_tcpip_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_channel *i = (struct tcpip_channel *) o;
  mark((struct lsh_object *) i->socket);
}

struct lsh_class tcpip_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "tcpip_channel", sizeof(struct tcpip_channel),
  do_tcpip_channel_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct tcpip_connected
{
  struct fd_callback super;
  struct tcpip_channel *channel;
  struct io_backend *backend;
  UINT32 block_size;
  struct channel_open_callback *response;
};
extern struct lsh_class tcpip_connected_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_tcpip_connected_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_connected *i = (struct tcpip_connected *) o;
  mark((struct lsh_object *) i->channel);
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->response);
}

struct lsh_class tcpip_connected_class =
{ STATIC_HEADER,
  &fd_callback_class, "tcpip_connected", sizeof(struct tcpip_connected),
  do_tcpip_connected_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct open_direct_tcpip
{
  struct channel_open super;
  struct io_backend *backend;
};
extern struct lsh_class open_direct_tcpip_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_open_direct_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_direct_tcpip *i = (struct open_direct_tcpip *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class open_direct_tcpip_class =
{ STATIC_HEADER,
  &channel_open_class, "open_direct_tcpip", sizeof(struct open_direct_tcpip),
  do_open_direct_tcpip_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

