#ifndef GABA_DEFINE
struct client_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  UINT32 block_size;
  const char * id_comment;
  struct randomness *random;
  struct make_kexinit *init;
  struct packet_handler *kexinit_handler;
};
extern struct lsh_class client_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_callback *i = (struct client_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->kexinit_handler);
}

struct lsh_class client_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "client_callback", sizeof(struct client_callback),
  do_client_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_line_handler
{
  struct line_handler super;
  struct ssh_connection *connection;
};
extern struct lsh_class client_line_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_line_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_line_handler *i = (struct client_line_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class client_line_handler_class =
{ STATIC_HEADER,
  &line_handler_class, "client_line_handler", sizeof(struct client_line_handler),
  do_client_line_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct accept_service_handler
{
  struct packet_handler super;
  int service_name;
  struct ssh_service *service;
};
extern struct lsh_class accept_service_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_accept_service_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct accept_service_handler *i = (struct accept_service_handler *) o;
  mark((struct lsh_object *) i->service);
}

struct lsh_class accept_service_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "accept_service_handler", sizeof(struct accept_service_handler),
  do_accept_service_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct service_request
{
  struct ssh_service super;
  int service_name;
  struct ssh_service *service;
};
extern struct lsh_class service_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_service_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct service_request *i = (struct service_request *) o;
  mark((struct lsh_object *) i->service);
}

struct lsh_class service_request_class =
{ STATIC_HEADER,
  &ssh_service_class, "service_request", sizeof(struct service_request),
  do_service_request_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct request_info
{
  struct lsh_object super;
  struct request_info *next;
  int want_reply;
  int essential;
  struct lsh_string * (*(format))(struct request_info *self, struct ssh_channel *c);
  int (*(result))(struct request_info *self, struct ssh_channel *c, int);
};
extern struct lsh_class request_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_request_info_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct request_info *i = (struct request_info *) o;
  mark((struct lsh_object *) i->next);
}

struct lsh_class request_info_class =
{ STATIC_HEADER,
  0, "request_info", sizeof(struct request_info),
  do_request_info_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_session
{
  struct ssh_channel super;
  struct request_info *requests;
  struct io_fd *in;
  struct io_fd *out;
  struct io_fd *err;
  int * exit_status;
};
extern struct lsh_class client_session_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_session *i = (struct client_session *) o;
  mark((struct lsh_object *) i->requests);
  mark((struct lsh_object *) i->in);
  mark((struct lsh_object *) i->out);
  mark((struct lsh_object *) i->err);
}

struct lsh_class client_session_class =
{ STATIC_HEADER,
  &ssh_channel_class, "client_session", sizeof(struct client_session),
  do_client_session_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exit_handler
{
  struct channel_request super;
  int * exit_status;
};
extern struct lsh_class exit_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class exit_handler_class =
{ STATIC_HEADER,
  &channel_request_class, "exit_handler", sizeof(struct exit_handler),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct client_startup
{
  struct connection_startup super;
  struct ssh_channel *session;
};
extern struct lsh_class client_startup_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_startup_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct client_startup *i = (struct client_startup *) o;
  mark((struct lsh_object *) i->session);
}

struct lsh_class client_startup_class =
{ STATIC_HEADER,
  &connection_startup_class, "client_startup", sizeof(struct client_startup),
  do_client_startup_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct pty_request
{
  struct request_info super;
  int tty;
  struct termios ios;
  struct lsh_string *term;
  UINT32 width;
  UINT32 height;
  UINT32 width_p;
  UINT32 height_p;
  struct lsh_string *modes;
};
extern struct lsh_class pty_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_pty_request_free(struct lsh_object *o)
{
  struct pty_request *i = (struct pty_request *) o;
  lsh_string_free(i->term);
  lsh_string_free(i->modes);
}

struct lsh_class pty_request_class =
{ STATIC_HEADER,
  &request_info_class, "pty_request", sizeof(struct pty_request),
  NULL,
  do_pty_request_free
};
#endif /* !GABA_DECLARE */

