/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#include "ttssh.h"
#include "util.h"

#define READAMOUNT 60000

void PKT_init(TInstVar FAR * pvar) {
  buf_create(&pvar->pkt_state.buf, &pvar->pkt_state.buflen);
  pvar->pkt_state.datastart = 0;
  pvar->pkt_state.datalen = 0;
  pvar->pkt_state.seen_server_ID = 0;
  pvar->pkt_state.seen_newline = 0;
}

static int recv_data(TInstVar FAR * pvar, unsigned long up_to_amount) {
  int amount_read;
  
  if (pvar->pkt_state.datastart != 0) {
    memmove(pvar->pkt_state.buf,
      pvar->pkt_state.buf + pvar->pkt_state.datastart,
      pvar->pkt_state.datalen);
    pvar->pkt_state.datastart = 0;
  }

  buf_ensure_size(&pvar->pkt_state.buf, &pvar->pkt_state.buflen, up_to_amount);

  amount_read = (pvar->Precv)(
    pvar->socket,
    pvar->pkt_state.buf + pvar->pkt_state.datalen,
    up_to_amount - pvar->pkt_state.datalen, 0);

  if (amount_read > 0) {
    if (!pvar->pkt_state.seen_server_ID && !pvar->pkt_state.seen_newline) {
      int i;

      for (i = 0; i < amount_read; i++) {
        if (pvar->pkt_state.buf[pvar->pkt_state.datalen + i] == '\n') {
          pvar->pkt_state.seen_newline = 1;
        }
      }
    }

    pvar->pkt_state.datalen += amount_read;
  } else if (!pvar->pkt_state.seen_server_ID && !pvar->pkt_state.seen_newline
    && pvar->pkt_state.datalen == up_to_amount) {
    pvar->pkt_state.seen_newline = 1;
  }

  return amount_read;
}

int PKT_recv(TInstVar FAR * pvar, char FAR * buf, int buflen) {
  int amount_in_buf = 0;
  int more_input_available = 1;

  while (SSH_is_any_payload(pvar) ? buflen > 0 : more_input_available) {
    if (SSH_is_any_payload(pvar)) {
      int grabbed = SSH_extract_payload(pvar, buf, buflen);

      amount_in_buf += grabbed;
      buf += grabbed;
      buflen -= grabbed;
    } else if (!pvar->pkt_state.seen_server_ID && pvar->pkt_state.seen_newline) {
      unsigned int i;

      for (i = 0; pvar->pkt_state.buf[i] != '\n' && i < pvar->pkt_state.datalen; i++) {
      }

      SSH_handle_server_ID(pvar, pvar->pkt_state.buf);

      pvar->pkt_state.seen_server_ID = 1;

      pvar->pkt_state.datastart += i + 1;
      pvar->pkt_state.datalen -= i + 1;
    } else if (pvar->pkt_state.datalen >= 4) {
      char * data = pvar->pkt_state.buf + pvar->pkt_state.datastart;
      uint32 realpktsize = get_uint32_MSBfirst(data);
      uint32 padding = 8 - (realpktsize % 8);
      uint32 pktsize = realpktsize + padding;
      
      if (pktsize + 4 <= pvar->pkt_state.datalen) {
        /* the data must be 4 byte aligned. */
        SSH_handle_packet(pvar, data + 4, pktsize, padding);

        pvar->pkt_state.datastart += pktsize + 4;
        pvar->pkt_state.datalen -= pktsize + 4;
      } else {
        int amount_read = recv_data(pvar, pktsize > READAMOUNT ? pktsize : READAMOUNT);
        
        if (amount_read == SOCKET_ERROR) {
          if (amount_in_buf == 0) {
            return SOCKET_ERROR;
          } else {
            return amount_in_buf;
          }
        } else {
          if (amount_read == 0) {
            more_input_available = 0;
          }
        }       
      }
    } else {
      int amount_read = recv_data(pvar, READAMOUNT);
      
      if (amount_read == SOCKET_ERROR) {
        if (amount_in_buf == 0) {
          return SOCKET_ERROR;
        } else {
          return amount_in_buf;
        }
      } else if (amount_read == 0) {
        more_input_available = 0;
      }
    }

    if (pvar->fatal_error) {
      return amount_in_buf;
    }
  }

  if (SSH_is_any_payload(pvar)) {
    PostMessage(pvar->NotificationWindow, WM_USER_COMMNOTIFY,
      pvar->socket, MAKELPARAM(FD_READ, 0));
  }
  
  return amount_in_buf;
}

void PKT_end(TInstVar FAR * pvar) {
  buf_destroy(&pvar->pkt_state.buf, &pvar->pkt_state.buflen);
}
