;; -*- Scheme -*-
;;
;; $Id: avl-tree13.scm,v 1.1 1998/03/16 07:57:21 foner Exp $

(require 'avl-tree:nil?)
(require 'avl-tree::left)
(require 'avl-tree::right)
(require 'avl-tree::data)

;;+doc
;; procedure: avl-tree:for-all-in-order
;; arguments: tree before[state key&data] after[state key&data] state
;; signature:
;;   forall a,b,c => avl-tree[a,b,c] x (d x c x -> d) x (d x c x -> d) x d -> d
;;
;; Applies BEFORE and AFTER to all KEY&DATA elements in TREE in order.
;; BEFORE is applied during the downward pass and AFTER is applied on the
;; upwards pass.
;;-doc

(define avl-tree:for-all-in-order
  (lambda (t b a s)
    (let loop ((t t) (s s))
      (if (avl-tree:nil? t)
	  s
	  (let ((d (avl-tree::data t)))
	    (loop (avl-tree::right t)
		  (a (loop (avl-tree::left t) (b s d)) d)))))))


;;+doc
;; procedure: avl-tree:for-all
;; arguments: tree action[state key&data] state
;; signature: forall a,b,c => avl-tree[a,b,c] x (d x c -> d) x d -> d
;;
;; Applies ACTION to all KEY&DATA elements in TREE in -some- order.
;;-doc

(define avl-tree:for-all avl-tree:for-all-in-order)

;; eof
